<?php

use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

use App\Http\Livewire\Home;
use App\Http\Livewire\Member;
use App\Http\Livewire\Lapangan;
use App\Http\Livewire\SendMail;
use App\Http\Livewire\SendMailMember;
use App\Http\Livewire\Register;
use App\Http\Livewire\Dashboard;
use App\Http\Livewire\PilihCabang;
use App\Http\Livewire\HargaMember;
use App\Http\Livewire\MemberAdmin;
use App\Http\Livewire\GalleryAdmin;
use App\Http\Livewire\DaftarBooking;
use App\Http\Livewire\DetailBooking;
use App\Http\Livewire\LapanganAdmin;
use App\Http\Livewire\PaketLapangan;
use App\Http\Livewire\TransaksiMember;
use App\Http\Livewire\TransaksiSukses;
use App\Http\Livewire\TransaksiLapangan;
use App\Http\Livewire\PaketLapanganAdmin;
use App\Http\Livewire\LaporanTransaksiMember;
use App\Http\Livewire\LaporanTransaksiLapangan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', PilihCabang::class)->name('pilih-cabang');
Route::get('/{branch}', Home::class)->name('home');
Route::get('/{branch}/login', [LoginController::class, 'index'])->name('login');
Route::post('/{branch}/login', [LoginController::class, 'login']);
Route::post('/account/logout', [LoginController::class, 'logout'])->name('logout');

Route::get('/{branch}/email/{konfirmasi}', SendMail::class)->name('send-mail');
Route::get('/{branch}/email-member/{memberId}', SendMailMember::class)->name('send-mail-member');

// User Route
Route::get('/{branch}/member', Member::class)->name('member');
Route::get('/{branch}/member/{telepon}/{kodeLapangan}/konfirmasi-pembayaran', TransaksiMember::class)->name('member.transaksi');

Route::get('/{branch}/{jenisLapangan}', Lapangan::class)->name('lapangan');
Route::get('/{branch}/{jenisLapangan}/lapangan-{noLapangan}/{kodeLapangan}/paket-harga', PaketLapangan::class)->name('paket.lapangan');
Route::get('/booking/detail-booking/{booking}', DetailBooking::class)->name('booking.lapangan');
Route::get('/{branch}/booking-lapangan/{konfirmasi}/{telepon}/konfirmasi-pembayaran', TransaksiLapangan::class)->name('lapangan.transaksi');
Route::get('/{branch}/booking/{kode_transaksi}/transaksi-sukses', TransaksiSukses::class)->name('transaksi.sukses');

// Admin Route
Route::group(['middleware' => ['auth', 'role:admin']], function() {  
  Route::get('/{branch}/admin/dashboard/register', Register::class)->name('register');
  Route::get('/{branch}/admin/kelola/lapangan', LapanganAdmin::class)->name('kelola.lapangan');
  Route::get('/{branch}/admin/kelola/lapangan/{id}/{kategori}', GalleryAdmin::class)->name('kelola.gallery');  
  Route::get('/{branch}/admin/kelola/paket-lapangan', PaketLapanganAdmin::class)->name('kelola.paket-lapangan');  
  Route::get('/admin/harga-member', HargaMember::class)->name('harga-member');
});


// Logged in Route
Route::group(['middleware' => 'auth'], function() {
  // Route::get('/admin/dashboard', Dashboard::class)->name('admin');

  Route::get('/{branch}/admin/kelola/laporan/pendaftaran-member', LaporanTransaksiMember::class)->name('kelola.transaksi-member');

  Route::get('/{branch}/admin/kelola/laporan/booking-lapangan', LaporanTransaksiLapangan::class)->name('kelola.transaksi-lapangan');

  Route::get('/{branch}/admin/daftar-booking', DaftarBooking::class)->name('daftar-booking');  
  Route::get('/{branch}/admin/kelola/member', MemberAdmin::class)->name('kelola.member');
});

Route::group(['middleware' => ['auth', 'role:operator']], function() {

});
