<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<title>Login</title>
	<meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
	<link rel="icon" href="../assets/img/icon.ico" type="image/x-icon"/>

	<!-- Fonts and icons -->
	<script src="../assets/js/plugin/webfont/webfont.min.js"></script>
	<script>
		WebFont.load({
			google: {"families":["Open+Sans:300,400,600,700"]},
			custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands"], urls: ['../assets/css/fonts.css']},
			active: function() {
				sessionStorage.fonts = true;
			}
		});
	</script>
	
	<!-- CSS Files -->
  <link rel="stylesheet" href="{{ asset('Dashboard/css/bootstrap.min.css') }}">
  <link rel="stylesheet" href="{{ asset('Dashboard/css/azzara.css') }}">

</head>
<body class="login">
	<div class="wrapper wrapper-login">
		<div class="container container-login animated fadeIn" style="box-shadow: 0 0 3px 3px #dbd5d5;">
			<h3 class="text-center">Login To System</h3>
			<div class="login-form">
				<form action="{{ route('login', ['branch' => $cbg]) }}" method="POST"> @csrf
					<div class="form-group">
						<label for="email" class="placeholder"><b>Email</b></label>
						<input id="email" name="email" type="email" class="form-control" required>
					</div>
					<div class="form-group">
						<label for="password" class="placeholder"><b>Password</b></label>
						{{-- <a href="#" class="link float-right">Forget Password ?</a> --}}
						<div class="position-relative">
							<input id="password" name="password" type="password" class="form-control" required>
							<div class="show-password">
								<i class="flaticon-interface"></i>
							</div>
						</div>
					</div>
					@if (session()->has('status-failed'))
					<div class="alert alert-danger block d-flex align-items-center mt-2 mx-2">
						{{ session('status-failed') }}
						<button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">
							<span class="font-weight-bold" aria-hidden="true">&times;</span>
						</button>		
					</div>
					@endif					
					<div class="form-group form-action-d-flex">
						{{-- <div class="custom-control custom-checkbox">
							<input type="checkbox" class="custom-control-input" id="rememberme">
							<label class="custom-control-label m-0" for="rememberme">Remember Me</label>
						</div> --}}
						<input type="submit" value="login" class="btn btn-primary float-right mt-2 fw-bold w-100">
					</div>
				</form>
        
        <a href="{{ route('pilih-cabang') }}" class="form-group form-action-d-flex ">
          <svg class="bg-danger w-50 p-2 text-white" style="height: 40px; width: 40px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16l-4-4m0 0l4-4m-4 4h18"></path></svg>
        </a>
			</div>
		</div>
	</div>

  <script src="{{ asset('Dashboard/js/core/jquery.3.2.1.min.js') }}"></script>
  <script src="{{ asset('Dashboard/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js') }}"></script>
  <script src="{{ asset('Dashboard/js/core/popper.min.js') }}"></script>
  <script src="{{ asset('Dashboard/js/core/bootstrap.min.js') }}"></script>
  <script src="{{ asset('Dashboard/js/ready.min.js') }}"></script>  
</body>
</html>