@section('header-menu') @include('layouts.partials.home.navbar') @endsection
@section('footer') @include('layouts.partials.home.footer') @endsection

<div class="container mt-4">
	
	<div class="p-3 mb-4" style="box-shadow: 0 0 3px 1px #888;">
		<h5 class="text-center text-uppercase fw-bold"> Rincian Biaya : </h5>
		<table class="table table-hovered table-bordered mt-3 text-center">
			<thead class="bg-secondary text-white">
				<tr>
					<td>Periode</td>
					<td>Waktu</td>
					<td>Harga</td>
				</tr>
			</thead>
			<tbody>
				@foreach ($memberDetail as $memde)
				<tr>
					<td> {{ $memde->bulan }} {{ $memde->tahun }} </td>
					<td> {{ $memde->jam_booking }} </td>
					<td> RP. {{ number_format($memde->harga , 0, ',', '.') }} </td>
				</tr>
				@endforeach
				<tr style="background: #f1f1f1;">
					<td></td>
					<td>Jumlah hari <span class="text-capitalize fw-bold"> {{ $memde->member->hari }} </span> dalam bulan <span class="text-capitalize fw-bold"> {{ $memde->member->bulan }} </span> : </td>
					<td> x <span class="fw-bold"> {{ $jumlahHari }} </span> </td>
				</tr>
				<tr style="background: #f1f1f1;">
					<td></td>
					<td class="text-uppercase fw-bold">Total Harga : </td>
					<td class="fw-bold"> RP. {{ number_format($harga , 0, ',', '.') }} </td>
				</tr>
			</tbody>
		</table>
	</div>

	<div class="row align-items-center">
		<div class="col-md-6 mb-3">
			<img src="{{ asset('images/icon/order-successful.png') }}" class="img-fluid">
		</div>
		<div class="col-md-6 mb-3 text-center">
			<h3 class="text-capitalize text-bg mb-3"> Pendaftaran Sebagai member Berhasil </h3>
			<small class="text-capitalize" style="font-size: 18px;"> silahkan lakukan pembayaran sebesar :  </small>
			<div class="d-flex justify-content-center my-3">
				<div class="border border-dark p-2 px-5" style="width: fit-content;">
				<h3 class="text-dark"> RP.	{{ number_format($this->harga , 0, ',', '.') }} </h3>
				</div>
			</div>
			<small class="text-capitalize" style="font-size: 18px;"> Pada Rekening :  </small>
			<div class="d-flex flex-column justify-content-center my-3">	
				<div class="d-flex justify-content-center mb-3">
					<img src="{{ asset($bank) }}" style="width: 150px; width: 150px;">
				</div>
				<div class="d-flex justify-content-center mb-1">
					<span class="border-top border-dark pt-2 fw-bold" style="width: fit-content;"> A/N. {{ $atas_nama }} </span>
				</div>
				<div class="d-flex justify-content-center">
					<div class="border border-dark p-2 px-5" style="width: fit-content;">
						<h3 class="text-dark"> {{ $rekening }} </h3>
					</div>
				</div>
			</div>
			<p class="text-capitalize" style="font-size: 18px;"> Dan Upload bukti pembayarannya. </p>
			<a data-bs-toggle="modal" href="#addData" role="button" class="btn nav-bg p-3 text-white"> Upload Bukti Pembayaran </a>
		</div>
	</div>

	<!-- Modal Add -->
	<div wire:ignore.self class="modal fade" id="addData" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="addData" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-xl">
			<div class="modal-content">
				<div class="modal-header nav-bg text-white px-4">
					<h5 class="modal-title" id="exampleModalToggleLabel">Upload Bukti Pembayaran</h5>
					<button type="button" class="bg-white p-2 btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<div class="form-group mb-3">
						<label>Bukti Pembayaran</label>
						<div class="custom-file">
							{{-- <input type="file" wire:model="photo" id="customFile" class="custom-file-input"> --}}
							<input type="file" wire:model="photo" class="form-control" id="inputGroupFile04">
							@error('photo') <small class="text-danger">{{$message}}</small> @enderror
						</div>
						@if ($photo)
							<label class="mt-3"> Preview Image</label>
							<div class="border border-secondary" style="width: 200px; height: auto;">
								<img src="{{ $photo->temporaryUrl() }}" alt="Preview Image" style="height: 100%; width: 100%; object-fit: cover;">
							</div>
						@endif
					</div>      
				</div>
				<div class="modal-footer">
					<button class="btn nav-bg text-white d-flex align-items-center" wire:click.prevent="store()">
						<span> Kirim Bukti </span>
						<svg class="text-white ms-2" style="height: 25px; width: 25px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
					</button>
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Add -->
</div>
