@section('navbar-dashboard')	@include('layouts.partials.dashboard.navbar')	@endsection
@section('sidebar-dashboard')	@include('layouts.partials.dashboard.sidebar')	@endsection
@section('register-active') active @endsection

<div class="main-panel">      
	<div class="content">
		<div class="page-inner">
			<div class="page-header">
				<ul class="breadcrumbs">
					<li class="nav-home">
						<a href="#">
							<i class="flaticon-home"></i>
						</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item">
						<a href="#">Master</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item text-info">
						<a href="#">User</a>
					</li>
				</ul>
			</div>

			@if (session()->has('info-success'))
			<div class="alert alert-success block d-flex align-items-center">
				{{ session('info-success') }}
				<button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">
					<span class="font-weight-bold" aria-hidden="true">&times;</span>
				</button>		
			</div>
			@endif

			<div class="card">
				<div style="border-top: 5px solid #f9cb1e;"></div>
				<div class="mt-3 border-bottom pb-3">              
					<div class="d-flex align-items-center">
						<div class="card-title mr-auto pl-3 font-weight-bold text-uppercase" style="border-left: 5px solid #007559; letter-spacing: 4px;">Kelola User</div>
						<div class="card-tools pr-3">
							@if ($selected_user)
							<button class="m-2 btn btn-danger btn-border btn-round btn-sm" data-toggle="modal" data-target="#deleteData" wire:click.prevent="edit({{ $selected_user }})">
								<span class="btn-label">
									<i class="fa fa-trash"></i>
								</span>
								Hapus Data
							</button>
							<button class="m-2 btn btn-secondary btn-border btn-round btn-sm" data-toggle="modal" data-target="#editData" wire:click.prevent="edit({{ $selected_user }})">
								<span class="btn-label">
									<i class="fa fa-edit"></i>
								</span>
								Edit Data
							</button>
							@endif
							<button class="m-2 btn btn-primary btn-border btn-round btn-sm" data-toggle="modal" data-target="#addData" wire:click.prevent="resetinput()">
								<span class="btn-label">
									<i class="fa fa-plus"></i>
								</span>
								Tambah Data
							</button>
						</div>
					</div>
				</div>

				<div class="card-body">
					<div class="table-responsive table-responsive-sm table-responsive-md table-responsive-lg table-responsive-xl">
						<table class="table table-hover text-center table-bordered table-striped">
							<thead class="bg-primary text-white font-weight-bold">
								<tr>
									<td></td>
									<td>#</td>
									<td>Nama</td>
									<td>Email</td>
									<td style="width: 120px;">Hak Akses</td>
									<td>Telepon</td>
								</tr>
							</thead>
							<tbody>
								@foreach ($users as $user)
								<tr>
									<td>
										<center class="form-check">
											<input class="form-check-input" type="radio" wire:click.prevent="action({{ $user->id }})"
											@if($selected_user == $user->id) checked @endif>
										</center>
									</td>
									<td>{{ $users->firstItem() + $loop->index }}</td>
									<td class="text-capitalize">{{ $user->name }}</td>
									<td>{{ $user->email }}</td>
									<td>
										<span class="text-capitalize font-weight-bold text-white px-4 py-2 {{ $user->role == 'admin' ? 'bg-primary' : 'bg-secondary' }}">
											{{ $user->role }}
										</span>
									</td>
									<td>{{ $user->telepon }}</td>
								</tr>
								@endforeach
							</tbody>
						</table>

						<div class="paginateContainer d-flex justify-content-center mt-2 mb-2">
							<div>
								{!! $users->links() !!}
								{{-- 'pagination::bootstrap-4' --}}
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Modal Add -->
	<div wire:ignore.self class="modal fade" id="addData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-primary">
					<h3 class="modal-title" id="exampleModalLabel">Tambah Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>														
				<div class="modal-body">
					<div class="form-group">
						<h3>Nama</h3>
						<input type="text" wire:model="name" class="form-control border border-dark">
						@error('name') <small class="text-danger">{{$message}}</small> @enderror
					</div>
					<div class="form-group">
						<h3>Email</h3>
						<input type="email" wire:model="email" class="form-control border border-dark">
						@error('email') <small class="text-danger">{{$message}}</small> @enderror
					</div>
					<div class="form-group">
						<h3>Password</h3>
						<input type="password" wire:model="password" class="form-control border border-dark">
						@error('password') <small class="text-danger">{{$message}}</small> @enderror
					</div>
					<div class="form-group">
						<h3>Telepon</h3>
						<input type="number" wire:model="telepon" class="form-control border border-dark">
						@error('telepon') <small class="text-danger">{{$message}}</small> @enderror
					</div>					
					<div class="form-group">
						<h3>Hak Akses</h3>
						<select wire:model="role" class="form-control border border-dark">
							<option value=""> --- </option>
							<option value="admin">Admin</option>
							<option value="operator">Operator</option>
						</select>
						@error('role') <small class="text-danger">{{$message}}</small> @enderror
					</div>        
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-primary" value="Tambah Data" wire:click.prevent="store()">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Add -->

	<!-- Modal Edit -->
	<div wire:ignore.self class="modal fade" id="editData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-secondary">
					<h3 class="modal-title" id="exampleModalLabel">Edit Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>														
				<div class="modal-body">
					<div class="form-group">
						<h3>Nama</h3>
						<input type="text" wire:model="name" class="form-control border border-dark">
						@error('name') <small class="text-danger">{{$message}}</small> @enderror
					</div>
					<div class="form-group">
						<h3>Email</h3>
						<input type="email" wire:model="email" class="form-control border border-dark">
						@error('email') <small class="text-danger">{{$message}}</small> @enderror
					</div>
					<div class="form-group">
						<h3>Ganti Password</h3>
						<input type="password" wire:model="password" class="form-control border border-dark">
						@error('password') <small class="text-danger">{{$message}}</small> @enderror
					</div>
					<div class="form-group">
						<h3>Telepon</h3>
						<input type="number" wire:model="telepon" class="form-control border border-dark">
						@error('telepon') <small class="text-danger">{{$message}}</small> @enderror
					</div>     
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-secondary" value="Edit Data" wire:click.prevent="update()">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Edit -->

	<!-- Modal Delete -->
	<div wire:ignore.self class="modal fade" id="deleteData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-danger">
					<h3 class="modal-title" id="exampleModalLabel">Hapus Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<h3> Yakin Ingin Menghapus Data ({{ $name }}) ? </h3>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn" style="background: #bdbdbd;" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-danger" value="Hapus Data" wire:click.prevent="destroy()">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Delete -->
</div>
