@section('css')
<style>
	ul.nav-pills li
	{
		border-radius: 10px !important;
		border: 1px solid #007559;
		margin: 1em 1em 1em 0;
	}

	ul.nav-pills li button.active
	{
		background: #007559 !important;
		border-radius: 10px !important;
	}

	.field-size
	{
		position: absolute;
		background: #00000050;
		padding: .5em 1em;
		color: #ffffff;
		top: 30%;
		text-transform: uppercase;
	}
</style>
@endsection

@section('header-menu') @include('layouts.partials.home.navbar') @endsection
@section('footer') @include('layouts.partials.home.footer') @endsection

<div>
	<div class="container mt-4">
		<h3 class="text-center text-bg text-uppercase"> {{ $field->nama_lapangan }} - {{ $field->nomor_lapangan }} </h3>

		<div style="height: 480px; width: 100%; margin-bottom: -3em;" class="mt-3">
			<img src="{{ $field->thumbnail ? asset('storage/galleries/'. $field->thumbnail) : asset('images/empty.jpg') }}" class="w-100 h-100 bg-white p-1" style="object-fit: cover; border-radius: 25px;">
		</div>

		<div class="d-flex justify-content-center">
			<h5 class="field-size"> Ukuran : {{ $field->ukuran_lapangan }} </h5>
		</div>
	</div>

	<div class="nav-bg py-5" style="z-index: -1;"></div>

	<div class="container" style="margin-top: -1em;">
		<div class="bg-white p-3" style="border-radius: 10px;">

			@if (session()->has('info-failed'))
			<div class="container">
				<div class="alert alert-danger block d-flex justify-content-between align-items-center my-3">
					{{ session('info-failed') }}
					<button type="button" class="bg-white p-2 btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
				</div>
			</div>
			@endif	

			<div class="d-flex justify-content-between align-items-end border border-success p-3 text-bg" style="border-radius: 10px;">
				<h6 class="mt-2 ms-1 me-3">{{ $today }}</h6>

				<div class="form-group mx-1">
					<h6 class="text-right">Tanggal Booking</h6>					
					<input type="date" wire:model="tanggal_booking" class="form-control border border-success" id="tgl_bk">			
				</div>   			
			</div>		

			<ul class="nav nav-pills my-2" id="pills-tab" role="tablist">
				<li class="nav-item" role="presentation">
					<button wire:ignore.self class="nav-link active" id="pills-jadwal-tab" data-bs-toggle="pill" data-bs-target="#pills-jadwal" type="button" role="tab" aria-controls="pills-jadwal" aria-selected="true">Harga Lapangan</button>
				</li>
				<li class="nav-item" role="presentation">
					<button wire:ignore.self class="nav-link" id="pills-terbooking-tab" data-bs-toggle="pill" data-bs-target="#pills-terbooking" type="button" role="tab" aria-controls="pills-terbooking" aria-selected="false">Lapangan Terbooking</button>
				</li>
				{{-- <li class="nav-item" role="presentation">
					<button wire:ignore.self class="nav-link" id="pills-gallery-tab" data-bs-toggle="pill" data-bs-target="#pills-gallery" type="button" role="tab" aria-controls="pills-gallery" aria-selected="false">Gallery</button>
				</li> --}}
			</ul>

			@if ($kategori == 'fitroom')
			<div class="">
				<div class="d-flex align-items-center my-3">
						<div class="d-flex align-items-center">
							<h6 class="mt-2 mr-1" style="min-width: 12em;">Ingin Menggunakan AC (+RP. 10.000 ) :</h6>
							<select wire:model="AirConditioner" class="form-control border border-dark mr-4" style="width: 100%;">
								<option value="no"> Tidak </option>
								<option value="yes"> Ya </option>
							</select>
						</div> 
					</div>
				</div>
			@endif
			
			<div class="tab-content" id="pills-tabContent">
				{{-- Daftar Harga --}}
				<div wire:ignore.self class="tab-pane fade show active" id="pills-jadwal" role="tabpanel" aria-labelledby="pills-jadwal-tab">
					@if (count($getPaket) > 0)
					<div class="col-md-12 mt-3">
						<div class="d-flex flex-column align-items-center border border-success p-3 mb-3 text-bg" style="border-radius: 10px;">
							<h5> Booking Anda </h5>
							<table class="table table-bordered table-hover table-stripped text-center">
								<thead class="bg-secondary text-white">
									<tr>
										<td>Tanggal</td>
										<td>Waktu</td>
										<td>Harga</td>
									</tr>
								</thead>
								<tbody>
									@foreach ($getPaket as $booking)
									<tr>
										<td> {{ $now->format('l, d F Y') }} </td>
										<td> {{ $booking->jam }} </td>
										<td> RP. {{ number_format($booking->harga , 0, ',', '.') }} </td>
									</tr>
									@endforeach
									@if ($AirConditioner == 'yes')
									<tr>
										<td class="text-uppercase fw-bold">Tambahan AC :</td>
										<td class="text-uppercase fw-bold"> RP. 10.000 x {{ $getPaket->count() }} JAM </td>
										<td class="">RP. {{ number_format($ac_price , 0, ',', '.') }}  </td>
									</tr>		
									@endif
									@if ($getPaket->count() >= 1)
									<tr>
										<td></td>
										<td class="text-uppercase fw-bold"> Total Harga :  </td>
										<td class="fw-bold">RP. {{ number_format($total_biaya , 0, ',', '.') }}</td>
									</tr>
									@endif
								</tbody>
							</table>
						</div>
					</div>
					@endif

					<h5 class=" text-danger text-center text-md-start fw-bold mt-3" style="font-style: italic;">* Waktu Booking Minimal Adalah 2 Jam *</h5>

					<div class="align-items-center mt-3 px-3 border border-success" style=" border-radius: 10px;">
						<h5 class=" text-bg text-center mt-3">Daftar Harga Sewa Lapangan</h5>
						
						<div class="row my-3 pt-3">
						@foreach ($pakets as $paket)			
						<!-- <div class="col-xs-6 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3"> -->
						<div class="col-12">
							<div class="mx-2 p-1 mb-3 rounded text-center text-uppercase" style="box-shadow: 0 0 3px 3px #cacaca; min-width: ; cursor: pointer;" onclick="document.getElementById('paket-({{ $paket->id }})').click()">
								<input type="checkbox" id="paket-({{ $paket->id }})" data-id="{{ $paket->id }}" 
								wire:model="selectedPaket.{{ $paket->id }}">

								<h5> {{ $paket->jam }} </h5>
								<h3> RP. {{ number_format($paket->harga , 0, ',', '.') }} </h3>
							</div>
						</div>
						@endforeach
						</div>
					</div>			
				</div>
				{{-- End Daftar Harga --}}

				{{-- Jadwal Terbooking --}}
				<div wire:ignore.self class="tab-pane fade" id="pills-terbooking" role="tabpanel" aria-labelledby="pills-terbooking-tab">
					<div class="border border-success p-3 text-bg" style="border-radius: 10px;">
						
						<h5 class="text-center"> Daftar Lapangan Terbooking </h5>

						<div class="row justify-content-center mt-4">
							@foreach ($booked_field as $fields)			
							<div class="col-xs-6 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3">
								<div class="mx-2 p-1 mb-3 rounded text-center text-uppercase 
								@if ($fields->transaksiLapangan->bukti_transaksi && $fields->transaksiLapangan->status == 'belum_bayar') bg-secondary text-white 
								@elseif ($fields->transaksiLapangan->bukti_transaksi && $fields->transaksiLapangan->status == 'lunas' or $fields->transaksiLapangan->status == 'member') bg-success text-white 
								@elseif (!$fields->transaksiLapangan->bukti_transaksi) bg-danger text-white
								@endif" 
								style="box-shadow: 0 0 3px 3px #cacaca; min-width: 200px;">
									<div class="d-flex flex-column justify-content-center mt-2">
										<center>

											{{-- Menunggu Konfirmasi --}}
											@if ($fields->transaksiLapangan->bukti_transaksi && $fields->transaksiLapangan->status == 'belum_bayar') 
											<svg style="height: 25px; width: 25px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
											{{-- Lunas --}}
											@elseif ($fields->transaksiLapangan->bukti_transaksi && $fields->transaksiLapangan->status == 'lunas' or $fields->transaksiLapangan->status == 'member') 
											<svg style="height: 25px; width: 25px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>

											{{-- Belum Bayar --}}
											@elseif (!$fields->transaksiLapangan->bukti_transaksi) 
											<svg style="height: 25px; width: 25px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
											@endif											
										</center>
										<p class="mt-2">
											@if ($fields->transaksiLapangan->bukti_transaksi && $fields->transaksiLapangan->status == 'belum_bayar') Menunggu Konfirmasi 
											@elseif ($fields->transaksiLapangan->bukti_transaksi && $fields->transaksiLapangan->status == 'lunas' or $fields->transaksiLapangan->status == 'member') Terbooking 
											@elseif (!$fields->transaksiLapangan->bukti_transaksi) Belum Bayar
											@endif											
										</p>
									</div>
									
									<h5> {{ $fields->jam_booking }} </h5>
									<h3> RP. {{ number_format($fields->harga , 0, ',', '.') }} </h3>
								</div>
							</div>
							@endforeach
						</div>
						
					</div>
				</div>
				{{-- End Jadwal Terbooking --}}

				{{-- Kumpulan Foto --}}
				<div wire:ignore.self class="tab-pane fade" id="pills-gallery" role="tabpanel" aria-labelledby="pills-terbooking-tab">
					<div class="border border-success p-3 text-bg" style="border-radius: 10px;">
						<div class="container">
							<p class="mb-3 pb-2 text-bg text-center border-bottom border-success" style="font-size: 26px;">Kumpulan Foto</p>					
							<div class="portfolio-item row justify-content-center">
								@foreach ($galleries as $gallery)
								<div class="item col-lg-3 col-md-4 col-6 col-sm">
									<div class="bg-white p-1">
										<a href="{{ $gallery->photo ? asset('storage/galleries/'. $gallery->photo) : '' }}" class="fancylight popup-btn" data-fancybox-group="light">
											<img class="img-fluid" src="{{ $gallery->photo ? asset('storage/galleries/'. $gallery->photo) : '' }}" alt="">
										</a>
									</div>
								</div>
								@endforeach			
							</div>      					
						</div>
					</div>
				</div>
				{{-- End Kumpulan Foto --}}
			</div>

			@if (count($getPaket) > 1)
			<div class="fix-bawah bg-white p-3">
				<div class="container">
					<div class="container">
						<a class="btn btn-primary w-100 text-uppercase" data-bs-toggle="modal" href="#detailBooking" role="button" {{ $getPaket->count() < 1 ? 'disabled' : 'null' }}>Booking Sekarang</a>
					</div>
				</div>
			</div>
			@endif			

		</div>
	</div>

	{{-- Modal Detail Booking --}}
	<div wire:ignore.self class="modal fade" id="detailBooking" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="detailBooking" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-xl">
			<div class="modal-content">
				<div class="modal-header nav-bg text-white px-4">
					<h5 class="modal-title" id="exampleModalToggleLabel">Booking Anda</h5>
					<button type="button" class="bg-white p-2 btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<div>
						<div class="text-center">
							<h4> Periksa Pesanan Anda </h4>
							<h6> Pastikan keterangan pesanan berikut sudah sesuai dan benar. </h6>
						</div>
						<div class="container mt-4">
							@foreach ($getPaket as $pket)
							<div class="mx-2 p-3 mb-3 rounded text-uppercase" style="box-shadow: 0 0 3px 3px #cacaca; min-width: 200px;">			
								<div class="row justify-content-between">
									<div class="col-md-6">
										<h5 class="mt-2"> {{ $field->nama_lapangan }} - {{ $field->nomor_lapangan }} </h5>
										<div class="d-flex flex-column">
											<span> {{ $now->format('l, d F Y') }} </span>
											<span> {{ $pket->jam }} </span>
										</div>
									</div>
									<div class="col-md-6">
										<h5 class="d-flex justify-content-end"> RP. {{ number_format($pket->harga , 0, ',', '.') }} </h5>
									</div>
								</div>
							</div>
							@endforeach
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button class="btn nav-bg text-white d-flex align-items-center" data-bs-target="#isiBiodata" data-bs-toggle="modal">
						<span> Isi Data Diri Anda </span>
						<svg class="text-white ms-2" style="height: 25px; width: 25px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
					</button>
				</div>
			</div>
		</div>
	</div>
	{{-- End Modal Detail Booking --}}

	{{-- Modal Biodata --}}
	<div wire:ignore.self class="modal fade" id="isiBiodata" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="exampleModalToggle2" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-xl">
			<div class="modal-content">
				<div class="modal-header nav-bg text-white px-4">
					<h5 class="modal-title" id="exampleModalToggleLabel2">Isi Data Diri</h5>
					<button type="button" class="bg-white p-2 btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<div class="form-group mb-3">
						<h5>Nama</h5>
						<input type="text" wire:model="nama" class="form-control border border-dark">
						@error('nama') <small class="text-danger">{{$message}}</small> @enderror
					</div>
					<div class="form-group mb-3">
						<h5>Nomor HP</h5>
						<div class="d-flex align-items-center rounded">
							<div class="border border-dark d-flex align-items-center" style="background: #f0f0f0; padding: .35em .5em ;">
								<img src="{{ asset('images/flags/indonesia.png') }}" style="width: 24px; height: 24px;">
								<span class="ms-2">+62</span>
							</div>
							<input type="number" wire:model="telepon" class="form-control border border-dark" style="border-radius: 0;">
						</div>
						@error('telepon') <small class="text-danger">{{$message}}</small> @enderror
					</div>
					<div class="form-group mb-3">
						<h5>Alamat</h5>
						<textarea wire:model="alamat" cols="30" rows="5" class="form-control border border-dark"></textarea>
						@error('alamat') <small class="text-danger">{{$message}}</small> @enderror
					</div>  
					<div class="form-group mb-3">
						<h5>Email</h5>
						<input type="email" wire:model="email" class="form-control border border-dark">
						@error('email') <small class="text-danger">{{$message}}</small> @enderror
					</div>						
				</div>
				<div class="modal-footer">
					<button class="btn btn-secondary d-flex align-items-center" data-bs-target="#detailBooking" data-bs-toggle="modal">
						<svg class="text-white me-2" style="height: 25px; width: 25px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
						<span> Kembali </span>
					</button>
					<input type="submit" class="btn nav-bg text-white" value="Bayar Sekarang" wire:click.prevent="store()">
				</div>
			</div>
		</div>
	</div>
	{{-- End Modal Biodata --}}
</div>

@section('js')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>

<script>
function myFunction() {
	var element = document.getElementById("myDIV");
	element.classList.toggle("nav-bg");
}

$(function(){
    var dtToday = new Date();
    
    var month = dtToday.getMonth() + 1;
    var day = dtToday.getDate();
    var year = dtToday.getFullYear();
    if(month < 10)
        month = '0' + month.toString();
    if(day < 10)
        day = '0' + day.toString();
    
    var maxDate = year + '-' + month + '-' + day;
    $('#tgl_bk').attr('min', maxDate);
});

$(function(){
    var dtToday = new Date();
    
    var month = dtToday.getMonth() + 1;
    var day = dtToday.getDate();
    var year = dtToday.getFullYear();
   
    $('#tgl_bk').attr('min', maxDate);
});
</script>
@endsection
