@section('navbar-dashboard')	@include('layouts.partials.dashboard.navbar')	@endsection
@section('sidebar-dashboard')	@include('layouts.partials.dashboard.sidebar')	@endsection
@section('paket_lapangan-active') active @endsection

<div class="main-panel">      
	<div class="content">
		<div class="page-inner">
			<div class="page-header">
				<ul class="breadcrumbs">
					<li class="nav-home">
						<a href="#">
							<i class="flaticon-home"></i>
						</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item">
						<a href="#">Master</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item">
						<a href="#">Lapangan</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item text-info">
						<a href="#">Harga Paket Lapangan</a>
					</li>
				</ul>
			</div>

			@if (session()->has('info-success'))
			<div class="alert alert-success block d-flex align-items-center">
				{{ session('info-success') }}
				<button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">
					<span class="font-weight-bold" aria-hidden="true">&times;</span>
				</button>		
			</div>
			@endif

			<div class="card">
				<div style="border-top: 5px solid #f9cb1e;"></div>
				<div class="mt-3 border-bottom pb-3">              
					<div class="d-flex align-items-center">
						<div class="card-title mr-auto pl-3 font-weight-bold text-uppercase" style="border-left: 5px solid #007559; letter-spacing: 4px;">Kelola Paket Lapangan</div>
						<div class="card-tools pr-3">
							@if ($selected_paket)
							<button class="m-2 btn btn-danger btn-border btn-round btn-sm" data-toggle="modal" data-target="#deleteData">
								<span class="btn-label">
									<i class="fa fa-trash"></i>
								</span>
								Hapus Data
							</button>
							<button class="m-2 btn btn-secondary btn-border btn-round btn-sm" data-toggle="modal" data-target="#editData" wire:click.prevent="edit({{ $selected_paket }})">
								<span class="btn-label">
									<i class="fa fa-edit"></i>
								</span>
								Edit Data
							</button>
							@endif
							<button class="m-2 btn btn-primary btn-border btn-round btn-sm" data-toggle="modal" data-target="#addData">
								<span class="btn-label">
									<i class="fa fa-plus"></i>
								</span>
								Tambah Data
							</button>
						</div>
					</div>
				</div>

				<div class="row ml-2">
					<div class="col-md-7">
						<div class="d-flex align-items-center my-3">
							<div class="d-flex align-items-center">
								<h3 class="mt-2 mr-1" style="min-width: 5.8em;">Filter Paket :</h3>
								<select wire:model="filter_lapangan" class="form-control border border-dark mr-4" style="width: 100%;">
									<option value=""> Semua </option>
									@foreach ($fields as $field)
									<option value="{{ $field->id }}"> {{ $field->nama_lapangan }} - {{ $field->nomor_lapangan }} </option>
									@endforeach
								</select>
							</div> 
						</div>
					</div>

					<div class="col-md-5">
						<div class="d-flex align-items-center my-3">
							<div class="d-flex align-items-center">
								<h3 class="mt-2 mr-1" style="min-width: 5.8em;">Filter Hari :</h3>
								<select wire:model="filter_hari" class="form-control border border-dark mr-4" style="width: 100%;">
									<option value=""> Semua </option>
									<option value="no"> Weekday </option>
									<option value="yes"> Weekend </option>
								</select>
							</div>
						</div>
					</div>
				</div>

				<div class="mx-4 mt-2">					
					<div class="table-responsive table-responsive-sm table-responsive-md table-responsive-lg table-responsive-xl">
						<table class="table table-hover text-center table-bordered table-striped">
							<thead class="bg-primary text-white font-weight-bold">
								<tr>
									<td></td>
									<td>#</td>
									<td>Nama Lapangan</td>
									<td>Kode Paket</td>
									<td>Jam</td>
									<td>Weekend</td>
									<td>Harga</td>
								</tr>
							</thead>
							<tbody>
								@foreach ($pakets as $paket)
								<tr>
									<td>
										<div class="form-check">
											<input class="form-check-input" type="radio" wire:click.prevent="action({{ $paket->id }})"
											@if($selected_paket == $paket->id) checked @endif>
										</div>
									</td>
									<td>{{ $pakets->firstItem() + $loop->index }}</td>
									<td>{{ $paket->lapangan->nama_lapangan }} - {{ $paket->lapangan->nomor_lapangan }} </td>
									<td>{{ $paket->kode_paket }}</td>
									<td>{{ $paket->jam }}</td>
									<td class="text-uppercase">{{ $paket->weekend }}</td>
									<td>RP. {{ number_format($paket->harga , 0, ',', '.') }}</td>
								</tr>
								@endforeach
							</tbody>
						</table>

						<div class=" d-flex justify-content-center my-2">
							<div style="margin-left: 6em">
								{!! $pakets->links() !!}
								{{-- 'pagination::bootstrap-4' --}}
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Modal Add -->
	<div wire:ignore.self class="modal fade" id="addData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-primary">
					<h3 class="modal-title" id="exampleModalLabel">Tambah Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>														
				<div class="modal-body">
					<div class="form-group">
						<h3>Kode Lapangan</h3>
						<select wire:model="lapangan_id" class="form-control border border-dark">
							<option value=""> --- </option>
							@foreach ($kode_lapangan as $klp)
								<option value="{{ $klp->id }}"> [{{ $klp->kode_lapangan }}] {{ $klp->nama_lapangan }} - {{ $klp->nomor_lapangan }} </option>	
							@endforeach
						</select>
						@error('lapangan_id') <small class="text-danger">{{$message}}</small> @enderror
					</div>   
					<div class="form-group">
						<h3>Kode Paket</h3>
						<input type="text" wire:model="kode_paket" class="form-control border border-dark">
						@error('kode_paket') <small class="text-danger">{{$message}}</small> @enderror
					</div>    
					<div class="form-group">
						<h3>Jam</h3>
						<input type="text" wire:model="jam" class="form-control border border-dark">
						@error('jam') <small class="text-danger">{{$message}}</small> @enderror
					</div> 
					<div class="form-group">
						<h3>Weekend</h3>
						<select wire:model="weekend" class="form-control border border-dark">
							<option value=""> --- </option>
							<option value="yes"> Yes </option>
							<option value="no"> No </option>
						</select>
						@error('weekend') <small class="text-danger">{{$message}}</small> @enderror
					</div>    
					<div class="form-group">
						<h3>Harga</h3>
						<input type="number" wire:model="harga" class="form-control border border-dark">
						@error('harga') <small class="text-danger">{{$message}}</small> @enderror
					</div>    
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-primary" value="Tambah Paket" wire:click.prevent="store()">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Add -->	

	<!-- Modal Edit -->
	<div wire:ignore.self class="modal fade" id="editData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-secondary">
					<h3 class="modal-title" id="exampleModalLabel">Edit Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>														
				<div class="modal-body">
					<div class="form-group">
						<h3>Kode Lapangan</h3>
						<select wire:model="lapangan_id" class="form-control border border-dark" disabled>
							<option value="{{ $lapangan_id }}"> {{ $nama_lapangan }} - {{ $nomor_lapangan }} </option>
						</select>
						@error('lapangan_id') <small class="text-danger">{{$message}}</small> @enderror
					</div>   
					<div class="form-group">
						<h3>Kode Paket</h3>
						<input type="text" wire:model="kode_paket" class="form-control border border-dark">
						@error('kode_paket') <small class="text-danger">{{$message}}</small> @enderror
					</div>    
					<div class="form-group">
						<h3>Jam</h3>
						<input type="text" wire:model="jam" class="form-control border border-dark">
						@error('jam') <small class="text-danger">{{$message}}</small> @enderror
					</div>   
					<div class="form-group">
						<h3>Weekend</h3>
						<select wire:model="weekend" class="form-control border border-dark">
							<option value=""> --- </option>
							<option value="yes"> Yes </option>
							<option value="no"> No </option>
						</select>
						@error('weekend') <small class="text-danger">{{$message}}</small> @enderror
					</div>    
					<div class="form-group">
						<h3>Harga</h3>
						<input type="number" wire:model="harga" class="form-control border border-dark">
						@error('harga') <small class="text-danger">{{$message}}</small> @enderror
					</div>    
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-secondary" value="Edit Paket" wire:click.prevent="update()">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Edit -->	

	<!-- Modal Delete -->
	<div wire:ignore.self class="modal fade" id="deleteData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-danger">
					<h3 class="modal-title" id="exampleModalLabel">Hapus Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<h3> Yakin Ingin Menghapus Data ? </h3>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn" style="background: #bdbdbd;" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-danger" value="Hapus Data" wire:click.prevent="destroy({{ $selected_paket }})">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Delete -->	
</div>
