@section('header-menu') @include('layouts.partials.home.navbar') @endsection
@section('footer') @include('layouts.partials.home.footer') @endsection

<div>
	{{-- Benefit --}}
	<div class="container mt-4">
		<div class="border border-success p-1 bg-white" style="border-radius: 25px; margin-bottom: -2.5em; position: relative;">
			<div class="">
				<div class="nav-bg px-3 py-4 text-white" style="border-top-left-radius: 25px; border-top-right-radius: 25px;">
					<h4 class="text-uppercase font-weight-bold text-italic text-center">Keuntungan sebagai member</h4>
				</div>
				<table class="table table-bordered table-hover">
					<tbody>
						<tr>
							<td class="w-50">
									<div class="d-flex align-items-center">
									<span style="font-size: 15px;"> Booking Langsung Di Peroses </span>
								</div>
							</td>
							<td>
								<div class="d-flex justify-content-center">
								<svg style="height: 25px; width: 25px;" class="text-success" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path></svg>
								</div>
							</td>
						</tr>
						<tr>
							<td class="w-50">
									<div class="d-flex align-items-center">
									<span style="font-size: 15px;"> Kepastian lapangan yang sudah pasti dapat </span>
								</div>
							</td>
							<td>
								<div class="d-flex justify-content-center">
								<svg style="height: 25px; width: 25px;" class="text-success" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path></svg>
								</div>
							</td>
						</tr>
						<tr>
							<td class="w-50">	
								<span style="font-size: 15px;"> Dapatkan fasilitas untuk menjadi prioritas member di cabang Fithall lainnya </span>
							</td>
							<td>
								<div class="d-flex justify-content-center">
								<svg style="height: 25px; width: 25px;" class="text-success" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path></svg>
								</div>
							</td>
						</tr>
						<tr>
							<td class="w-50">
									
									<span style="font-size: 15px;"> Undangan nonton bareng </span>
							</td>
							<td>
								<div class="d-flex justify-content-center">
								<svg style="height: 25px; width: 25px;" class="text-success" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path></svg>
								</div>
							</td>
						</tr>
						<tr>
							<td class="w-50">
									
									<span style="font-size: 15px;"> Update  give away yang akan di infokan di IG : 
										<a class="text-decoration-none" href="https://www.instagram.com/fithall_jkt/">@fithall_jkt  </a>	
									</span>
							</td>
							<td>
								<div class="d-flex justify-content-center">
								<svg style="height: 25px; width: 25px;" class="text-success" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path></svg>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			
		</div>
	</div>
	{{-- End Benefit --}}

	<div class="nav-bg py-5" style="z-index: -1;"></div>

	<div class="container" style="margin-top: -1em;">
		<div class="bg-white py-3 px-3" style="border-radius: 10px;">
		</div>
	</div>	

	@if (session()->has('info-failed'))
  <div class="container">
    <div class="alert alert-danger block d-flex justify-content-between align-items-center my-3 mx-4">
      {{ session('info-failed') }}
      <button type="button" class="bg-white p-2 btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  </div>
  @endif
	
	{{-- Daftar --}}
	<div class="container" style="margin-top: -1em;">
		<div class="bg-white p-3" style="border-radius: 10px;">
			<div class="border border-success p-1" style="border-radius: 25px;">
				<div class="bg-primary p-3" style="border-top-left-radius: 25px; border-top-right-radius: 25px;">
					<h3 class="text-white font-weight-bold"> Daftar Member </h3>
				</div>
				<div class="p-3">					
					<div class="alert alert-success border border-success block d-flex align-items-center">
						<h5 class=" text-uppercase text-italic"> Harga Membership = Total Harga Per Jam * Jumlah Hari Yang Sama Dalam Bulan Yang Dipilih </h5>
					</div>

					<div>
						<h5>Periode Membership (Bulan)</h5>
						<div class="d-lg-flex align-items-end border border-dark py-2 px-3 rounded">						
							@if ($tanggal_member)
							<h5 class="mb-3 mb-lg-0 px-3 py-2 border border-dark text-uppercase"> Bulan Terpilih : <span class="text-success"> {{ $bulan }} {{ $tahun }} </h5>
							@endif
							<div class="form-group ms-auto">
								<h6 class="text-end">Pilih Bulan Sebagai Member</h6>					
								<input type="month" wire:model="tanggal_member" class="form-control border border-success" id="tgl_bk">			
							</div>  
						</div>
					</div>

					@if ($tanggal_member)
					{{-- Hari --}}
					<div class="form-group mt-3">
						<h5>Hari</h5>
						<select wire:model="hari" class="form form-control border border-dark text-capitalize">
							<option value=""> --- </option>
							<option value="Senin">senin</option>
							<option value="Selasa">selasa</option>
							<option value="Rabu">rabu</option>
							<option value="Kamis">kamis</option>
							<option value="Jumat">jum'at</option>
							<option value="Sabtu">sabtu</option>
							<option value="Minggu">minggu</option>
						</select>
					</div>	
					{{-- End Hari --}}
					
					{{-- Lapangan --}}
					<div class="row">
						<div class="{{ !$jenis_lapangan ? null : 'col-md-6'}}">
							<div class="form-group mt-3">
								<h5>Jenis Lapangan</h5>
								<select wire:model="jenis_lapangan" class="form-control border border-dark">
									<option value=""> -- Pilih Jenis Lapangan -- </option>
									<option value="badminton">BADMINTON</option>
									@if ($cabang == 'mampang')
										<option value="fitroom">FITROOM</option>
									@elseif ($cabang == 'kalibata')
										<option value="tenis_meja">TENIS MEJA</option>
									@endif
								</select>
								@error('jenis_lapangan') <small class="text-danger">{{$message}}</small> @enderror
							</div>
						</div>
						@if ($jenis_lapangan)								
						<div class="col-md-6">
							<div class="form-group mt-3">
								<h5>Nomor Lapangan</h5>
								<select wire:model="nomor_lapangan" class="form-control border border-dark">
									<option value=""> -- Nomor Lapangan -- </option>
									@foreach ($no_lapangan as $nomor)
										<option value="{{ $nomor->nomor_lapangan }}">{{ $nomor->nomor_lapangan }}</option>
									@endforeach
								</select>
								@error('nama') <small class="text-danger">{{$message}}</small> @enderror
							</div>
						</div>
						@endif
					</div>
					{{-- End Lapangan --}}
					@endif		

					{{-- Daftar Harga --}}
					@if($this->nomor_lapangan)
					<h5 class=" text-danger text-center text-md-start fw-bold mt-3" style="font-style: italic;">* Waktu Booking Minimal Adalah 2 Jam *</h5>

					<div class="align-items-center mt-3 px-3 border border-dark rounded">
						<h5 class=" text-center mt-3">Daftar Harga Sewa Lapangan</h5>
						
						<div class="row my-3 pt-3">
						@foreach ($pakets as $paket)			
						<div class="col-xs-6 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3">
							<div class="mx-2 p-1 mb-3 rounded text-center text-uppercase" style="box-shadow: 0 0 3px 3px #cacaca; min-width: ; cursor: pointer;" onclick="document.getElementById('paket-({{ $paket->id }})').click()">
								<input type="checkbox" id="paket-({{ $paket->id }})" data-id="{{ $paket->id }}" 
								wire:model="selectedPaket.{{ $paket->id }}">

								<h5> {{ $paket->jam }} </h5>
								<h3> RP. {{ number_format($paket->harga , 0, ',', '.') }} </h3>
							</div>
						</div>
						@endforeach
						</div>
					</div>		
					@endif
					{{-- End Daftar Harga --}}
				
					<div class="border-dark border p-3 mt-4 rounded">
						<div class="form-group mt-3">
							<h5>Nama</h5>
							<input type="text" wire:model="nama" class="form-control border border-dark">
							@error('nama') <small class="text-danger">{{$message}}</small> @enderror
						</div>					
						<div class="form-group mt-3">
							<h5>Nomor HP</h5>
							<div class="d-flex align-items-center rounded">
								<div class="border border-dark d-flex align-items-center" style="background: #f0f0f0; padding: .35em .5em;">
									<img src="{{ asset('images/flags/indonesia.png') }}" style="width: 24px; height: 24px;">
									<span class="ms-2">+62</span>
								</div>						
								<input type="number" wire:model="telepon" class="form-control border border-dark" style="border-radius: 0;">
							</div>
							@error('telepon') <small class="text-danger">{{$message}}</small> @enderror
						</div>
						<div class="form-group mt-3">
							<h5>Alamat</h5>
							<textarea wire:model="alamat" cols="30" rows="5" class="form-control border border-dark"></textarea>
							@error('alamat') <small class="text-danger">{{$message}}</small> @enderror
						</div>  
						<div class="form-group mt-3">
							<h5>Email</h5>
							<input type="email" wire:model="email" class="form-control border border-dark">
							@error('email') <small class="text-danger">{{$message}}</small> @enderror
						</div>
					</div>
				</div>

				<div class="border-top border-secondary mt-3"></div>
				<div class="d-flex align-items-center justify-content-between">
					<div class="ms-3">
						@if ($getPaket->count() < 1)
						<h5 class=" text-danger text-center text-md-start fw-bold mt-3" style="font-style: italic;">* Waktu Booking Minimal Adalah 2 Jam *</h5>
						@endif
					</div>
					<div class="d-flex justify-content-end p-3">
						<a href="" class="btn btn-danger mx-2">Kembali</a>
						<input type="submit" class="btn btn-primary mx-2" value="Daftar Sekarang" wire:click.prevent="store()" {{ $getPaket->count() < 1 ? 'disabled' : '' }} >
					</div>
				</div>
			</div>

		</div>
	</div>
	{{-- End Daftar --}}

</div>
