@section('navbar-dashboard')	@include('layouts.partials.dashboard.navbar')	@endsection
@section('sidebar-dashboard')	@include('layouts.partials.dashboard.sidebar')	@endsection
@section('member-active')  active  @endsection

<div class="main-panel">      
	<div class="content">
		<div class="page-inner">
			<div class="page-header">
				<ul class="breadcrumbs">
					<li class="nav-home">
						<a href="#">
							<i class="flaticon-home"></i>
						</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item">
						<a href="#">Transaksi</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item text-info">
						<a href="#">Daftar Member</a>
					</li>
				</ul>
			</div>

			@if (session()->has('info-success'))
			<div class="alert alert-success block d-flex align-items-center">
				{{ session('info-success') }}
				<button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">
					<span class="font-weight-bold" aria-hidden="true">&times;</span>
				</button>		
			</div>
			@endif

			<div class="card">
				<div style="border-top: 5px solid #f9cb1e;"></div>
				<div class="mt-3 border-bottom pb-3">              
					<div class="d-flex align-items-center">
						<div class="card-title mr-auto pl-3 font-weight-bold text-uppercase" style="border-left: 5px solid #007559; letter-spacing: 4px;">Kelola Daftar Member</div>
						<div class="card-tools pr-3">
							@if ($selected_member)
							<button class="m-2 btn btn-primary btn-border btn-round btn-sm" data-toggle="modal" data-target="#detailTransaksi" wire:click.prevent="edit({{ $selected_member }})">
								<span class="btn-label">
									<i class="fa fa-clipboard mr-1"></i>
								</span>
								Detail Booking
							</button>							
							<button class="m-2 btn btn-secondary btn-border btn-round btn-sm" data-toggle="modal" data-target="#editData" wire:click.prevent="edit({{ $selected_member }})">
								<span class="btn-label">
									<i class="fa fa-edit"></i>
								</span>
								Edit Data
							</button>
							@endif
						</div>
					</div>
				</div>

				<div class="border border-dark mt-3 mb-2 p-2 mx-4">
					<div class="d-flex align-items-center">
						<input type="text" wire:model.debounce.300ms="searchTerm" class="form-control form-control-sm pr-5" style="border: none !important; box-shadow: none !important;" placeholder="Cari Berdasarkan Nama, Telepon atau Status">

						@if($this->searchTerm)
							<svg style="position: absolute; right: 5em;" height="25px" width="25px" class="text-danger" wire:click.prevent="resetSearch()" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>          
						@endif

						<svg height="25px" width="25px" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
					</div>					
				</div>	

				<div class="mx-4 mt-3 mb-4">
					<div class="table-responsive table-responsive-sm table-responsive-md table-responsive-lg table-responsive-xl">
						<table class="table table-hover text-center table-bordered table-striped">
							<thead class="bg-primary text-white font-weight-bold">
								<tr>
									<td></td>
									<td>#</td>
									<td style="min-width: 210px !important;">Status</td>
									<td style="min-width: 130px;">Down Payment</td>
									<td style="min-width: 100px;">Hari</td>
									<td style="min-width: 100px;">Periode</td>
									<td style="min-width: 100px !important;">Expired</td>
									<td style="min-width: 250px;">Nama</td>
									<td>Nomor HP</td>
									<td>Email</td>
									<td style="min-width: 150px;">Alamat</td>
									<td style="width: 15%;" colspan="2">Bukti Pembayaran</td>
								</tr>
							</thead>
							<tbody>
								@foreach ($members as $tran)
								<tr>
									<td>
										<div class="form-check">
											<input class="form-check-input" type="radio" wire:click.prevent="action({{ $tran->id }})"
											@if($selected_member == $tran->id) checked @endif>
										</div>
									</td>
									<td>{{ $members->firstItem() + $loop->index }}</td>									
									<td>
										<span class="px-3 py-1 text-white text-uppercase @if ($tran->status_bayar == 'sudah_bayar' AND $tran->status == 'belum_bayar') bg-warning text-dark  @elseif ($tran->status_bayar == 'belum_bayar' AND $tran->status == 'belum_bayar') bg-danger @elseif ($tran->status_bayar == 'sudah_bayar' AND $tran->status == 'down_payment') bg-info text-white @elseif ($tran->status_bayar == 'lunas' AND $tran->status == 'active') nav-bg @elseif ($tran->status_bayar == 'lunas' AND $tran->status == 'expired') bg-dark @endif">

											@if ($tran->status_bayar == 'sudah_bayar' AND $tran->status == 'belum_bayar') Menunggu Verifikasi
											@elseif ($tran->status_bayar == 'sudah_bayar' AND $tran->status == 'down_payment') Down Payment
											@elseif ($tran->status_bayar == 'belum_bayar' AND $tran->status == 'belum_bayar') Belum Bayar
											@elseif ($tran->status_bayar == 'lunas' AND $tran->status == 'active') Active
											@elseif ($tran->status_bayar == 'lunas' AND $tran->status == 'expired') Expired
											@endif

										</span>
									</td>									
									<td> {{ $tran->down_payment ? 'RP. '. number_format($tran->down_payment , 0, ',', '.') : null }} </td>
									<td class="text-capitalize">{{ $tran->hari }}</td>
									<td>{{ Carbon\Carbon::parse($tran->bulan)->format('F Y') }}</td>
									<td>{{ Carbon\Carbon::parse($tran->bulan)->addMonths(1)->format('F Y') }}</td>
									<td>{{ $tran->nama }}</td>
									<td>{{ $tran->telepon }}</td>
									<td>{{ $tran->email }}</td>
									<td>{{ $tran->alamat }}</td>
									<td> 
										<button data-toggle="modal" data-target="#seeBukti" class="btn border border-dark py-1 px-2 text-dark" wire:click.prevent="detail({{ $tran->id }})">
											<i class="fa fa-eye mr-1"></i>
											Lihat
										</button>
									</td>
								</tr>
								@endforeach
							</tbody>
						</table>

						<div class="paginateContainer d-flex justify-content-center mt-2 mb-2">
							<div>
								{!! $members->links() !!}
								{{-- 'pagination::bootstrap-4' --}}
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>	

	<!-- Modal Edit -->
	<div wire:ignore.self class="modal fade" id="editData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-secondary">
					<h3 class="modal-title" id="exampleModalLabel">Edit Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>														
				<div class="modal-body">
					<div class="form-group">
						<h3>Status</h3>
						<select wire:model="status" class="form-control border border-dark">
							@if($stat == 'belum_bayar')
								<option value="" style="font-size: 16px;">---</option>
								<option value="active" style="font-size: 16px;">Active</option>
								<option value="tidak_valid" style="font-size: 16px;">Tidak Valid</option>
								<option value="down_payment" style="font-size: 16px;">Down Payment</option>
								@elseif($stat == 'down_payment')
								<option value="active" style="font-size: 16px;">Active</option>
								@elseif($stat == 'active')
								<option value="" style="font-size: 16px;">---</option>
								<option value="expired" style="font-size: 16px;">Expired</option>
								@elseif($stat == 'expired')
								<option value="" style="font-size: 16px;">---</option>
								<option value="active" style="font-size: 16px;">Active</option>
								@endif					
						</select>
						@error('status') <small class="text-danger">{{$message}}</small> @enderror
					</div> 
					@if ($status == "down_payment")
						<div class="form-group">
							<h3>Jumlah Down Payment</h3>
							<input type="number" wire:model="down_payment" class="form-control border border-dark">
						</div>
					@endif						    
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-secondary" value="Edit Data" wire:click.prevent="update()">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Edit -->

	<!-- Modal Bukti -->
	<div wire:ignore.self class="modal fade" id="seeBukti" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" style="width: fit-content; margin: 2em auto;">
			<div class="modal-content">														
				<div class="modal-body d-flex flex-column">
					<button type="button" class="close mb-3 ml-auto" data-dismiss="modal" aria-label="Close">
						<svg style="height: 24px; width: 24px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
					</button>
					
					<img src="{{ $bukti ? asset('storage/bukti_pembayaran/'. $bukti) : asset('images/empty.jpg') }}" style="max-height: 550px; width: 100%;">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Bukti -->

	<!-- Detail Booking -->
	<div wire:ignore.self class="modal fade" id="detailTransaksi" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
			<div class="modal-content">			
				<div class="modal-header bg-primary">
					<h3 class="modal-title" id="exampleModalLabel">Detail Booking</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>				
				
				<div class="modal-body d-flex flex-column">
					@if ($selected_member)
					@foreach ($memberDetails as $detail)

					<span class="mx-2 mb-2" style="font-size: 14px;"> A/N : {{ $detail->member->nama }} </span>

					<div class="mx-2 p-3 mb-3 rounded text-uppercase" style="box-shadow: 0 0 3px 3px #cacaca; min-width: 200px;">			
						<div class="row justify-content-between align-items-end">
							<div class="col-md-6">
								<h5 class="mt-2 border-bottom border-dark pb-2 mb-2" style="width: fit-content;">[{{ $detail->lapangan->kode_lapangan }}] {{ $detail->lapangan->nama_lapangan }} - {{ $detail->lapangan->nomor_lapangan }} </h5>
								<div class="d-flex flex-column">
									{{-- <h4> {{ Carbon\Carbon::parse($detail->tanggal_booking)->format('F Y') }} </h4> --}}
									<h4> {{ $detail->jam_booking }} </h4>
								</div>
							</div>
							<div class="col-md-6">
								<h4 class="d-flex justify-content-end font-weight-bold"> RP. {{ number_format($detail->harga , 0, ',', '.') }} </h4>
							</div>
						</div>
					</div>
					@endforeach
					@endif
				</div>
			</div>
		</div>
	</div>
	<!-- End Detail Booking -->
</div>
