@section('navbar-dashboard')	@include('layouts.partials.dashboard.navbar')	@endsection
@section('sidebar-dashboard')	@include('layouts.partials.dashboard.sidebar')	@endsection
@section('laporan-active') active @endsection
@section('transaksi-member-active') active @endsection

<div class="main-panel">      
	<div class="content">
		<div class="page-inner">
			<div class="page-header">
				<ul class="breadcrumbs">
					<li class="nav-home">
						<a href="#">
							<i class="flaticon-home"></i>
						</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item">
						<a href="#">Kelola</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item text-info">
						<a href="#">Laporan</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item text-info">
						<a href="#">Pendaftaran Member</a>
					</li>
				</ul>
			</div>

			@if (session()->has('info-success'))
			<div class="alert alert-success block d-flex align-items-center">
				{{ session('info-success') }}
				<button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">
					<span class="font-weight-bold" aria-hidden="true">&times;</span>
				</button>		
			</div>
			@endif

			<div class="card">
				<div style="border-top: 5px solid #f9cb1e;"></div>
				<div class="mt-3 border-bottom pb-3">              
					<div class="d-flex align-items-center">
						<div class="card-title mr-auto pl-3 font-weight-bold text-uppercase" style="border-left: 5px solid #007559; letter-spacing: 4px;">Laporan Transaksi Pendaftaran Member</div>
						<div class="card-tools pr-3">
							{{-- <button class="m-2 btn btn-success btn-border btn-round btn-sm" data-toggle="modal" data-target="#addData" wire:click.prevent="resetinput()">
								<div class="d-flex align-items-center">
								<svg style="height: 20px; width: 20px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path></svg>
								<span class="ml-2"> Print Data </span>
								</div>
							</button> --}}
						</div>
					</div>
				</div>

				<div class="mx-4 mt-3 border border-dark p-3">
					<div class="d-flex align-items-cente text-uppercase font-weight-bold">
						<span class="text-primary mt-1"> Jumlah Transaksi : <span class="text-dark"> {{ $jumlah_transaksi }} </span> </span>
						<span class="mx-3" style="font-size: 16px;"> | </span>
						<span class="text-primary mt-1"> Jumlah Pemasukan : <span class="text-dark">RP. {{ number_format($jumlah_pemasukan , 0, ',', '.') }} </span> </span>
					</div>
				</div>

				<div class="card-body">
					<div class="table-responsive table-responsive-sm table-responsive-md table-responsive-lg table-responsive-xl">
						<table class="table table-hover text-center table-bordered table-striped">
							<thead class="bg-primary text-white font-weight-bold">
								<tr>
									<td>#</td>
									<td>Nama</td>
									<td>Telepon</td>
									<td>Bulan</td>
									<td>Hari</td>
									<td>Biaya</td>
									<td style="width: 15%;" colspan="2">Bukti Pembayaran</td>
								</tr>
							</thead>
							<tbody>
								@foreach ($trans as $tran)
								<tr>
									<td>{{ $trans->firstItem() + $loop->index }}</td>
									<td class="text-capitalize">{{ $tran->member->nama }}</td>
									<td>{{ $tran->member->telepon }}</td>
									<td>{{ Carbon\Carbon::parse($tran->member->bulan)->format('F Y') }}</td>
									<td class="text-capitalize">{{ $tran->member->hari }}</td>
									<td>RP. {{ number_format($tran->total_biaya , 0, ',', '.') }}</td>
									<td> 
										<a data-toggle="modal" data-target="#seeBukti" class="btn border border-dark py-1 px-2 text-dark" wire:click.prevent="detail({{ $tran->member_id }})">
											<i class="fa fa-eye mr-1"></i>
											Lihat
										</a>
									</td>
								</tr>
								@endforeach
							</tbody>
						</table>

						<div class="paginateContainer d-flex justify-content-center mt-2 mb-2">
							<div>
								{!! $trans->links() !!}
								{{-- 'pagination::bootstrap-4' --}}
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Modal Bukti -->
	<div wire:ignore.self class="modal fade" id="seeBukti" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" style="width: fit-content; margin: 2em auto;">
			<div class="modal-content">														
				<div class="modal-body d-flex flex-column">
					<button type="button" class="close mb-3 ml-auto" data-dismiss="modal" aria-label="Close">
						<svg style="height: 24px; width: 24px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
					</button>
					
					<img src="{{ asset('storage/bukti_pembayaran/'. $bukti) }}" style="height: 550px; width: auto;">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Bukti -->
</div>
