@section('header-menu') @include('layouts.partials.home.navbar') @endsection
@section('footer') @include('layouts.partials.home.footer') @endsection

<div>
  {{-- Jumbotron --}}
  <div class="jumbotron nav-bg pt-3 pb-5" style="border-radius: 0 !important;">
    <div class="container d-flex flex-column justify-content-center">
      <h3 class="text-uppercase text-italic text-gold">Welcome Fit-People, Lokasi Lapangan Olahraga Terbaik </h3>
      <p class="lead text-gold mb-3 text-capitalize">
      Fithall  memberikan kamu kemudahan untuk termpat berolahraga dengan berbagai type lapangan olahraga dan dapat di sewa untuk kegiatan acara special kalian seperti perkawinan, foto session, pernikahan. Kedepan kamu juga bisa bergabung dengan beragam komunitas olahraga untuk bermain bersama! nantikan
      </p>
      <div class="d-flex align-items-center">
        <p class="lead text-gold mb-3 text-capitalize mt-3 me-2">
          ingin menjadi member ?
        </p>
        <div class="bg-white p-1 rounded border border-dark">
          <a href="{{ route('member', ['branch' => $cabang]) }}" class="btn btn-sm bg-primary text-white font-weight-bold">Daftar Sekarang</a>
        </div>
      </div>
    </div>
  </div>
  {{-- End Jumbotron --}}
  
  {{-- Search --}}
  <div class="container content-home">
    <div class="d-flex home-group bg-white">
      <a class="btn btn-primary w-100 text-uppercase pt-sm-2 pt-md-2 pt-lg-2 pt-3">Pilih Lapangan</a>
      <a class="btn bg-white w-100 text-uppercase" data-bs-toggle="modal" href="#searchPembayaran" role="button">Upload Bukti Pembayaran</a>
    </div>
  </div>
  {{-- End Search --}}
  
  @if (session()->has('info-success'))
  <div class="container">
    <div class="alert alert-success block d-flex justify-content-between align-items-center my-3">
      {{ session('info-success') }}
      <button type="button" class="bg-white p-2 btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  </div>
  @endif
  
  @if (session()->has('info-failed'))
  <div class="container">
    <div class="alert alert-danger block d-flex justify-content-between align-items-center my-3">
      {{ session('info-failed') }}
      <button type="button" class="bg-white p-2 btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  </div>
  @endif
  
  {{-- Lapangan --}}
  @if ($cabang)
    @if ($cabang == 'mampang')
      <div class="container mt-4 product-container">
        <p class="" style="font-size: 22px;">Booking Lapangan <span style="font-size: 18px;"> ( Pilih Lapangan ) </span> </p>
        <div class="row">
          <div class="col-md-6 mb-3">
            <a href="{{ route('lapangan', ['jenisLapangan' => 'badminton', 'branch' => $cabang]) }}">
              <div class="card product-list">
                <div class="product-item">
                  <img src="{{ asset('images/badminton-2.jpg') }}" class="img-fluid">
                  <span>Badminton</span>
                </div>
              </div>
            </a>
          </div>
      
          <div class="col-md-6 mb-5">
            <a href="{{ route('lapangan', ['jenisLapangan' => 'fitroom', 'branch' => $cabang]) }}">
              <div class="card product-list">
                <div class="product-item">
                  <img src="{{ asset('images/fitroom.jpg') }}" class="img-fluid">
                  <span>FitRoom</span>
                </div>
              </div>
            </a>
          </div>
        </div>
      </div>
    @elseif ($cabang == 'kalibata')
      <div class="container mt-4 product-container">
        <p class="" style="font-size: 22px;">Booking Lapangan <span style="font-size: 18px;"> ( Pilih Lapangan ) </span> </p>
        <div class="row">
          <div class="col-md-6 mb-3">
            <a href="{{ route('lapangan', ['jenisLapangan' => 'badminton', 'branch' => $cabang]) }}">
              <div class="card product-list">
                <div class="product-item">
                  <img src="{{ asset('images/badminton-2.jpg') }}" class="img-fluid">
                  <span>Badminton</span>
                </div>
              </div>
            </a>
          </div>
      
          <div class="col-md-6 mb-5">
            <a href="{{ route('lapangan', ['jenisLapangan' => 'tenis_meja', 'branch' => $cabang]) }}">
              <div class="card product-list">
                <div class="product-item">
                  <img src="{{ asset('images/tennis-table.jpg') }}" class="img-fluid">
                  <span>Tenis Meja</span>
                </div>
              </div>
            </a>
          </div>
        </div>
      </div>
    @endif
  @endif
  {{-- End Lapangan --}}

  {{-- Offering --}}
  <div style="background: ;">
    <div class="mx-1 py-3 d-flex align-items-center">
      <div class="text-bg mx-2 mb-2">||</div>
      <div class="border-bg w-100"></div>
      <div class="text-bg mx-2 mb-2">||</div>
      <div class="border-bg w-100"></div>
      <div class="text-bg mx-2 mb-2">||</div>
    </div>
  </div>

  <center class="container">
    <div class="row">
      <div class="col-6 col-sm-6 col-md-3 mb-4 offering-card">
        <div class="rounded px-2 pt-3">
          <img src="https://img.icons8.com/ios/120/000000/hockey-field.png"/>
          <div class="mt-3">
            <h6>Fasilitas Pilihan</h6>
            <span style="font-size: 13px;">Booking Lapangan Olahraga Terbaik</span>
          </div>
        </div>
      </div>
      <div class="col-6 col-sm-6 col-md-3 mb-4 offering-card">
        <div class="rounded px-2 pt-3">
          <img src="https://img.icons8.com/ios/120/000000/yoga.png"/>
          <div class="mt-3">
            <h6>Ragam Aktifitas</h6>
            <span style="font-size: 13px;">Berbagai Jenis Olahraga Favorit</span>
          </div>
        </div>
      </div>
      <div class="col-6 col-sm-6 col-md-3 mb-1 offering-card">
        <div class="rounded px-2 pt-3">
          <img src="https://img.icons8.com/ios/120/000000/checked-user-male.png"/>
          <div class="mt-3">
            <h6>Jaringan Pelatih Olahraga</h6>
            <span style="font-size: 13px;">Praktisi Olahraga Sesuai Prefensi</span>
          </div>
        </div>
      </div>
      <div class="col-6 col-sm-6 col-md-3 mb-1 offering-card">
        <div class="rounded px-3 pt-3">
          <img src="https://img.icons8.com/external-kiranshastry-lineal-kiranshastry/120/000000/external-credit-card-finance-kiranshastry-lineal-kiranshastry-1.png"/>
          <div class="mt-3">
            <h6>Pembayaran Digital</h6>
            <span style="font-size: 13px;">Pembayaran Melalui Media Transfer</span>
          </div>
        </div>
      </div>
    </div>
  </center>

  <div style="background: ;">
    <div class="mx-1 pt-3 d-flex align-items-center">
      <div class="text-bg mx-2 mb-2">||</div>
      <div class="border-bg w-100"></div>
      <div class="text-bg mx-2 mb-2">||</div>
      <div class="border-bg w-100"></div>
      <div class="text-bg mx-2 mb-2">||</div>
    </div>
  </div>  
  {{-- End Offering --}}
  
  {{-- Gallery --}}
  <div class="mt-3 product-offering nav-bg">
    <div class="container py-4">
      <p class="mb-4 text-white" style="font-size: 26px;">Kumpulan Foto</p>
      <div class="portfolio-menu mt-2 mb-4 mx-2">
        <ul>
            <li class="btn btn-outline-light active mb-2" data-filter="*">All</li>
            @foreach ($fields as $field)
              <li class="btn btn-outline-light text-uppercase mb-2" data-filter=".{{ $field->kategori }}">{{ $field->kategori }}</li>
            @endforeach
        </ul>
      </div>
      <div class="portfolio-item row">
        @foreach ($galleries as $gallery)
        <div class="item col-lg-3 col-md-4 col-6 col-sm {{ $gallery->lapangan->kategori }}">
          <div class="bg-white p-1">
            <a href="{{ $gallery->photo ? asset('storage/galleries/'. $gallery->photo) : '' }}" class="fancylight popup-btn" data-fancybox-group="light">
              <img class="img-fluid" src="{{ $gallery->photo ? asset('storage/galleries/'. $gallery->photo) : '' }}" alt="">
            </a>
          </div>
        </div>
        @endforeach			
      </div>      
  
    </div>
  </div>
  {{-- End Gallery --}}
  
  {{-- Modal Search --}}
  <div wire:ignore.self class="modal fade" id="searchPembayaran" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="searchPembayaran" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" style="min-width: 95%;">
      <div class="modal-content">
        <div class="modal-header nav-bg text-white px-4">
          <h5 class="modal-title" id="exampleModalToggleLabel">Upload Bukti Pembayaran</h5>
          <button type="button" class="bg-white p-2 btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div>
            <div class="text-center">
              <h4> Pilih Pembayaran Yang Ingin Dilakukan </h4>
              <div class="">
                <div class="border-top border-dark"></div>
              </div>
            </div>
            <div class="mt-3">  
              <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation">
                  <button wire:ignore.self class="nav-link" id="pendaftaran-member-tab" data-bs-toggle="pill" data-bs-target="#pendaftaran-member" type="button" role="tab" aria-controls="pendaftaran-member" aria-selected="false">Pendaftaran Member</button>
                </li>
                <li class="nav-item" role="presentation">
                  <button wire:ignore.self class="nav-link active" id="booking-lapangan-tab" data-bs-toggle="pill" data-bs-target="#booking-lapangan" type="button" role="tab" aria-controls="booking-lapangan" aria-selected="true">Booking Lapangan</button>
                </li>
              </ul>
  
              <div class="tab-content" id="pills-tabContent">
                <div wire:ignore.self class="tab-pane fade border border-primary rounded p-2" id="pendaftaran-member" role="tabpanel" aria-labelledby="pendaftaran-member-tab">
                  {{-- Lapangan --}}
                  <div class="row mb-4 mx-1">
                    <div class="{{ !$jenis_lapangan ? null : 'col-md-6'}}">
                      <div class="form-group mt-3">
                        <h5>Jenis Lapangan</h5>
                        <select wire:model="jenis_lapangan" class="form-control border border-dark">
                          <option value=""> -- Pilih Jenis Lapangan -- </option>
                          <option value="badminton">BADMINTON</option>
                          @if ($cabang == 'mampang')
                          <option value="fitroom">FITROOM</option>
                          @elseif ($cabang == 'kalibata')
                            <option value="tenis_meja">TENIS MEJA</option>
                          @endif                          
                        </select>
                        @error('jenis_lapangan') <small class="text-danger">{{$message}}</small> @enderror
                      </div>
                    </div>
                    @if ($jenis_lapangan)								
                    <div class="col-md-6">
                      <div class="form-group mt-3">
                        <h5>Nomor Lapangan</h5>
                        <select wire:model="nomor_lapangan" class="form-control border border-dark">
                          <option value=""> -- Nomor Lapangan -- </option>
                          @foreach ($no_lapangan as $nomor)
                            <option value="{{ $nomor->nomor_lapangan }}">{{ $nomor->nomor_lapangan }}</option>
                          @endforeach
                        </select>
                        @error('nama') <small class="text-danger">{{$message}}</small> @enderror
                      </div>
                    </div>
                    @endif
                  </div>
                  {{-- End Lapangan --}}

                  <div class="d-flex">
                    <H6 class="mb-3 ms-2">Masukkan Nomor HP</H6>
                    <h6 class="mt-1 ms-2" style="font-size: 12px;">(Pendaftaran Member)</h6>
                  </div>
                  <div class="mx-2 p-1 mb-3 rounded text-uppercase" style="box-shadow: 0 0 3px 3px #cacaca; min-width: 200px;">	
                    <div class="d-flex align-items-center">
                      <div class="indo border border-dark d-flex align-items-center" style="background: #f0f0f0; padding: .35em .5em ; border-top-left-radius: 3px; border-bottom-left-radius: 3px;">
                        <img src="{{ asset('images/flags/indonesia.png') }}" style="width: 24px; height: 24px;">
                        <span class="ms-2">+62</span>
                      </div>

                      <div class="input-group">
                        <input type="number" class="form-control" wire:model="searchTransaksi" placeholder="Nomor HP Anda ..." aria-describedby="button-addon2">
                        <button class="btn btn-outline-primary" type="button" wire:click.prevent="cariMember" id="button-addon2">Cari</button>
                      </div>                    
                    </div>
                  </div>   
                </div>
                <div wire:ignore.self class="tab-pane fade border border-primary rounded p-2 show active" id="booking-lapangan" role="tabpanel" aria-labelledby="booking-lapangan-tab">
                  {{-- Lapangan --}}
                  <div class="row mb-4 mx-1">
                    <div class="{{ !$jenis_lapangan ? null : 'col-md-6'}}">
                      <div class="form-group mt-3">
                        <h5>Jenis Lapangan</h5>
                        <select wire:model="jenis_lapangan" class="form-control border border-dark">
                          <option value=""> -- Pilih Jenis Lapangan -- </option>
                          <option value="badminton">BADMINTON</option>
                          @if ($cabang == 'mampang')
                          <option value="fitroom">FITROOM</option>
                          @elseif ($cabang == 'kalibata')
                            <option value="tenis_meja">TENIS MEJA</option>
                          @endif                          
                        </select>
                        @error('jenis_lapangan') <small class="text-danger">{{$message}}</small> @enderror
                      </div>
                    </div>
                    @if ($jenis_lapangan)								
                    <div class="col-md-6">
                      <div class="form-group mt-3">
                        <h5>Nomor Lapangan</h5>
                        <select wire:model="nomor_lapangan" class="form-control border border-dark">
                          <option value=""> -- Nomor Lapangan -- </option>
                          @foreach ($no_lapangan as $nomor)
                            <option value="{{ $nomor->nomor_lapangan }}">{{ $nomor->nomor_lapangan }}</option>
                          @endforeach
                        </select>
                        @error('nama') <small class="text-danger">{{$message}}</small> @enderror
                      </div>
                    </div>
                    @endif
                  </div>
                  {{-- End Lapangan --}}

                  <div class="d-flex">
                    <H6 class="mb-3 ms-2">Masukkan Nomor HP</H6>
                    <h6 class="mt-1 ms-2" style="font-size: 12px;">(Booking Lapangan)</h6>
                  </div>
                  <div class="mx-2 p-1 mb-3 rounded text-uppercase" style="box-shadow: 0 0 3px 3px #cacaca; min-width: 200px;">			
                    <div class="d-flex align-items-center">
                      <div class="indo border border-dark d-flex align-items-center" style="background: #f0f0f0; padding: .35em .5em ; border-top-left-radius: 3px; border-bottom-left-radius: 3px;">
                        <img src="{{ asset('images/flags/indonesia.png') }}" style="width: 24px; height: 24px;">
                        <span class="ms-2">+62</span>
                      </div>                      
                      <div class="input-group">
                        <input type="number" class="form-control" wire:model="searchTransaksi" placeholder="Nomor HP Anda ..." aria-describedby="button-addon2">
                        <button class="btn btn-outline-primary" type="button" wire:click.prevent="cariBooking" id="button-addon2">Cari</button>
                      </div>                    
                    </div>              
                  </div>   
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  {{-- End Modal Search --}}
  
  </div>
  