@section('navbar-dashboard')	@include('layouts.partials.dashboard.navbar')	@endsection
@section('sidebar-dashboard')	@include('layouts.partials.dashboard.sidebar')	@endsection
@section('lapangan-active') active @endsection

<div class="main-panel">      
	<div class="content">
		<div class="page-inner">
			<div class="page-header">
				<ul class="breadcrumbs">
					<li class="nav-home">
						<a href="#">
							<i class="flaticon-home"></i>
						</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item">
						<a href="#">Kelola</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item text-info">
						<a href="{{ route('kelola.lapangan', ['branch' => $cabang]) }}">Lapangan</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item text-info">
						<a href="#">Gallery</a>
					</li>
				</ul>
			</div>

			<div class="text-uppercase font-weight-bold mt-5">
				<div class="d-flex align-items-center">
					<h2 class="font-weight-bold"> Nama Lapangan : </h2>
					<h2 class="font-weight-bold text-info ml-2">{{ $field->nama_lapangan }} - {{ $field->nomor_lapangan }}</h2>
				</div>
				<div style="border-top: 3px solid #888; width: 10em;" class="my-3"></div>
				<div class="d-flex align-items-center">
					<h2 class="font-weight-bold"> Kode Lapangan : </h2>
					<h2 class="font-weight-bold text-info ml-2">{{ $field->kode_lapangan }}</h2> 
				</div>
				<div style="border-top: 3px solid #888; width: 10em;" class="my-3"></div>
				<div class="d-flex align-items-center">
					<h2 class="font-weight-bold"> Kategori Lapangan : </h2>
					<h2 class="font-weight-bold text-info ml-2">{{ $field->kategori }}</h2> 
				</div>
			</div>			

			@if (session()->has('info-success'))
			<div class="alert alert-success block d-flex align-items-center my-3">
				{{ session('info-success') }}
				<button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">
					<span class="font-weight-bold" aria-hidden="true">&times;</span>
				</button>		
			</div>
			@endif

			<div class="p-3 rounded mt-3 bg-white" style="box-shadow: 0 0 2px 2px #9b9a9a !important;">
				<div class="d-flex align-items-center">
					<div class="card-title mr-auto pl-3 font-weight-bold text-uppercase" style="border-left: 5px solid #007559; letter-spacing: 4px;">Kelola Paket Lapangan</div>
					<div class="card-tools pr-3">
						@if ($selected_image)
						<button class="m-2 btn btn-danger btn-border btn-round btn-sm" data-toggle="modal" data-target="#deleteData" wire:click.prevent="get({{ $selected_image }})">
							<span class="btn-label">
								<i class="fa fa-trash"></i>
							</span>
							Hapus Data
						</button>
						<button class="m-2 btn btn-secondary btn-border btn-round btn-sm" data-toggle="modal" data-target="#editData" wire:click.prevent="edit({{ $selected_image }})">
							<span class="btn-label">
								<i class="fa fa-edit"></i>
							</span>
							Jadikan Thumbnail
						</button>
						@endif
						<button class="m-2 btn btn-primary btn-border btn-round btn-sm" data-toggle="modal" data-target="#addData">
							<span class="btn-label">
								<i class="fa fa-plus"></i>
							</span>
							Tambah Data
						</button>
					</div>
				</div>

				<div style="border-top: 3px solid #36a3f7;" class="my-3"></div>

				<div class="row justify-content-center">
					@foreach ($galleries as $gallery)
					<div class="col-md-3 mb-3 gvw mx-4">						
						<div class="rounded lapangan-list mt-2 gallery-view" style="margin-left: -2em;">
							<img src="{{ asset('storage/galleries/'. $gallery->photo) }}" class="w-100 h-100" style="object-fit: cover;">
							<a wire:click.prevent="action({{ $gallery->id }})">
								<svg fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
							</a>
						</div>
					</div>
					@endforeach
				</div>				
			</div>		
		</div>
	</div>

	<!-- Modal Add -->
	<div wire:ignore.self class="modal fade" id="addData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-primary">
					<h3 class="modal-title" id="exampleModalLabel">Tambah Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>														
				<div class="modal-body">
					<div class="form-group">
						<h3>Deskripsi</h3>
						<input type="text" wire:model="deskripsi" class="form-control border border-dark">
						@error('deskripsi') <small class="text-danger">{{$message}}</small> @enderror
					</div>
					<div class="form-group">
						<h3>Foto Lapangan</h3>
						<div class="custom-file">
							<input type="file" wire:model="photo" id="customFile" class="custom-file-input">
							<h3 for="customFile" class="custom-file-label"> Choose Image </h3>
							@error('photo') <small class="text-danger">{{$message}}</small> @enderror
						</div>
						@if ($photo)
							<h3 class="mt-3"> Preview Image</h3>
							<div class="border border-secondary" style="width: 350px; height: 150px;">
								<img src="{{ $photo->temporaryUrl() }}" alt="Preview Image" style="height: 100%; width: 100%; object-fit: cover;">
							</div>
						@endif
					</div>      
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-primary" value="Tambah Data" wire:click.prevent="store()">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Add -->

	<!-- Modal Edit -->
	<div wire:ignore.self class="modal fade" id="editData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-secondary">
					<h3 class="modal-title" id="exampleModalLabel">Thumbnail</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<h3> Jadikan gambar ini sebagai thumbnail ? </h3>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-secondary" value="Jadikan Thumbnail" wire:click.prevent="update({{ $img_id }})">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Edit -->

	<!-- Modal Delete -->
	<div wire:ignore.self class="modal fade" id="deleteData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-danger">
					<h3 class="modal-title" id="exampleModalLabel">Hapus Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<h3> Yakin Ingin Menghapus Data ? </h3>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn" style="background: #bdbdbd;" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-danger" value="Hapus Data" wire:click.prevent="destroy({{ $selected_image }})">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Delete -->		
</div>
