@section('navbar-dashboard')	@include('layouts.partials.dashboard.navbar')	@endsection
@section('sidebar-dashboard')	@include('layouts.partials.dashboard.sidebar')	@endsection
@section('booking-active')  active  @endsection

<div class="main-panel">      
	<div class="content">
		<div class="page-inner">
			<div class="page-header">
				<ul class="breadcrumbs">
					<li class="nav-home">
						<a href="#">
							<i class="flaticon-home"></i>
						</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item">
						<a href="#">Transaksi</a>
					</li>
					<li class="separator">
						<i class="flaticon-right-arrow"></i>
					</li>
					<li class="nav-item text-info">
						<a href="#">Daftar Booking</a>
					</li>
				</ul>
			</div>

			@if (session()->has('info-success'))
			<div class="alert alert-success block d-flex align-items-center">
				{{ session('info-success') }}
				<button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">
					<span class="font-weight-bold" aria-hidden="true">&times;</span>
				</button>		
			</div>
			@endif

			<div class="card">
				<div style="border-top: 5px solid #f9cb1e;"></div>
				<div class="mt-3 border-bottom pb-3">
					<div class="d-flex align-items-center">
						<div class="card-title mr-auto pl-3 font-weight-bold text-uppercase" style="border-left: 5px solid #007559; letter-spacing: 4px;">Kelola Daftar Booking</div>
						<div class="card-tools pr-3">
							@if ($selected_transaksi)
							<button class="m-2 btn btn-primary btn-border btn-round btn-sm" data-toggle="modal" data-target="#detailTransaksi" wire:click.prevent="edit({{ $selected_transaksi }})">
								<span class="btn-label">
									<i class="fa fa-clipboard mr-1"></i>
								</span>
								Detail Booking
							</button>
							<button class="m-2 btn btn-secondary btn-border btn-round btn-sm" data-toggle="modal" data-target="#editData" wire:click.prevent="edit({{ $selected_transaksi }})">
								<span class="btn-label">
									<i class="fa fa-edit"></i>
								</span>
								Edit Data
							</button>
							@endif
						</div>
					</div>
				</div>
				
				<div class="row ml-2">
					<div class="col-md-7">
						<div class="d-flex align-items-center my-3">
							<div class="d-flex align-items-center">
								<h3 class="mt-2 mr-1" style="min-width: 6.5em;">Filter Status :</h3>
								<select wire:model="filter_status" class="form-control border border-dark mr-4" style="width: 100%;">
									<option value=""> Semua </option>
									<option value="lunas"> Lunas </option>
									<option value="member"> Member </option>
									<option value="belum_bayar"> Belum Bayar </option>
								</select>
							</div>
						</div>
					</div>
				</div>

				<div class="border-bottom mb-3"></div>

				<div class="mx-4">
					<div class="row">
						<div class="col-md-4">
							<div class="d-flex align-items-center my-3">
								<div class="d-flex align-items-center">
									<h3 class="mt-2" style="min-width: 5.5em;">Tanggal :</h3>
									<input type="date" wire:model="filter_tanggal" class="form-control border border-dark">
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="d-flex align-items-center my-3">
								<div class="d-flex align-items-center">
									<h3 class="mt-2" style="min-width: 5.5em;">Bulan :</h3>
									<input type="month" wire:model="filter_bulan" class="form-control border border-dark">
								</div>
							</div>
						</div>
					</div>				
				</div>				

				<div class="border border-dark mt-1 p-2 mx-4">
					<div class="d-flex align-items-center">
						<input type="text" wire:model.debounce.300ms="searchTerm" class="form-control form-control-sm pr-5" style="border: none !important; box-shadow: none !important;" placeholder="Cari Berdasarkan Nama, Telepon atau Status">

						@if($this->searchTerm)
							<svg style="position: absolute; right: 5em;" height="25px" width="25px" class="text-danger" wire:click.prevent="resetSearch()" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>          
						@endif

						<svg height="25px" width="25px" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
					</div>					
				</div>	

				<div class="mx-4 mt-3 mb-4">
					<div class="table-responsive table-responsive-sm table-responsive-md table-responsive-lg table-responsive-xl">
						<table class="table table-hover text-center table-bordered table-striped">
							<thead class="bg-primary text-white font-weight-bold">
								<tr>
									<td></td>
									<td>#</td>
									<td>Kode Transaksi</td>
									<td>Jam Booking</td>
									<td style="min-width: 150px;">Tanggal Booking</td>
									<td style="min-width: 210px;">Status</td>
									<td style="min-width: 130px;">Down Payment</td>
									<td>Tanggal Bayar</td>
									<td>Jam Bayar</td>
									{{-- <td>Discount</td> --}}
									<td>Total Biaya</td>
									<td>Tambahan</td>
									<td>Nama</td>
									<td>Nomor HP</td>
									<td>Alamat</td>
									<td>Email</td>
									<td style="width: 15%;" colspan="2">Bukti Pembayaran</td>
								</tr>
							</thead>
							<tbody>
								@foreach ($transaksi as $tran)
								<tr>
									<td>
										<div class="form-check">
											<input class="form-check-input" type="radio" wire:click.prevent="action({{ $tran->id }})"
											@if($selected_transaksi == $tran->id) checked @endif>
										</div>
									</td>
									<td>{{ $transaksi->firstItem() + $loop->index }}</td>
									<td>{{ $tran->kode_transaksi }}</td>
									<td style="min-width: 100px;">{{ Carbon\Carbon::parse($tran->created_at)->format('H:i') }} </td>
									<td style="min-width: 100px;">{{ Carbon\Carbon::parse($tran->tanggal_booking)->format('d F Y') }} </td>									
									<td>
										<span class="px-3 py-1 text-white text-uppercase
										@if($tran->bukti_transaksi && $tran->status == 'belum_bayar') bg-warning text-dark @elseif($tran->status == 'belum_bayar') bg-danger @elseif($tran->status == 'lunas') bg-primary @elseif($tran->status == 'member') bg-secondary @elseif($tran->status == 'tidak_valid') bg-dark text-white @elseif($tran->status == 'down_payment') bg-info @endif">
											{{ $tran->bukti_transaksi && $tran->status == 'belum_bayar' ? 'Menunggu Verifikasi' : $tran->status }}
										</span>
									</td>

									<td> {{ $tran->down_payment ? 'RP. '. number_format($tran->down_payment , 0, ',', '.') : null }} </td>

									<td style="min-width: 150px;">{{ $tran->tanggal_bayar ? Carbon\Carbon::parse($tran->tanggal_bayar)->format('d F Y') : '' }} </td>
									<td style="min-width: 150px;">{{ $tran->tanggal_bayar ? Carbon\Carbon::parse($tran->tanggal_bayar)->format('H:i:s') : '' }} </td>
									{{-- <td>{{ $tran->discount }}%</td> --}}
									<td style="min-width: 120px;">RP. {{ number_format($tran->total_biaya , 0, ',', '.') }}</td>
									<td>{{ $tran->tambahan }}</td>
									<td style="min-width: 150px;">{{ $tran->nama }}</td>
									<td>{{ $tran->telepon }}</td>
									<td style="min-width: 120px;">{{ $tran->alamat }}</td>
									<td>{{ $tran->email }}</td>
									{{-- <td> 
										<a href="{{ asset('storage/bukti_pembayaran/'. $bukti) }}" class="btn border border-info py-1 px-2">
											<i class="fa fa-download mr-1" download></i>
											Download
										</a>
									</td> --}}
									<td> 
										<button data-toggle="modal" data-target="#seeBukti" class="btn border border-dark py-1 px-2 text-dark" wire:click.prevent="edit({{ $tran->id }})">
											<i class="fa fa-eye mr-1"></i>
											Lihat
										</button>
									</td>
								</tr>
								@endforeach
							</tbody>
						</table>

						<div class=" d-flex justify-content-center my-2">
							<div style="margin-left: 6em">
								{!! $transaksi->links() !!}
								{{-- 'pagination::bootstrap-4' --}}
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>	

	<!-- Modal Edit -->
	<div wire:ignore.self class="modal fade" id="editData" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-secondary">
					<h3 class="modal-title" id="exampleModalLabel">Edit Data</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>														
				<div class="modal-body">
					<div class="form-group">
						<h3>Status</h3>
						<select wire:model="status" class="form-control border border-dark">
							<option value="" style="font-size: 16px;">---</option>
							<option value="lunas" style="font-size: 16px;">Lunas</option>
							<option value="tidak_valid" style="font-size: 16px;">Tidak Valid</option>
							<option value="down_payment" style="font-size: 16px;">Down Payment</option>
						</select>						
						@error('status') <small class="text-danger">{{$message}}</small> @enderror
					</div> 
					@if ($status == "down_payment")
						<div class="form-group">
							<h3>Jumlah Down Payment</h3>
							<input type="number" wire:model="down_payment" class="form-control border border-dark">
						</div>
					@endif
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Tutup</button>
					<input type="submit" class="btn btn-secondary" value="Edit Data" wire:click.prevent="update()">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Edit -->

	<!-- Detail Booking -->
	<div wire:ignore.self class="modal fade" id="detailTransaksi" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
			<div class="modal-content">			
				<div class="modal-header bg-primary">
					<h3 class="modal-title" id="exampleModalLabel">Detail Booking</h3>
					<button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>				
				
				<div class="modal-body d-flex flex-column">
					@if ($selected_transaksi)					
					@foreach ($detail_transkasi as $detail)

					<span class="mx-2 mb-2" style="font-size: 14px;"> A/N : {{ $detail->transaksiLapangan->nama }} </span>

					<div class="mx-2 p-3 mb-3 rounded text-uppercase" style="box-shadow: 0 0 3px 3px #cacaca; min-width: 200px;">			
						<div class="row justify-content-between align-items-end">
							<div class="col-md-6">
								<h5 class="mt-2 border-bottom border-dark pb-2 mb-2" style="width: fit-content;">[{{ $detail->lapangan->kode_lapangan }}] {{ $detail->lapangan->nama_lapangan }} - {{ $detail->lapangan->nomor_lapangan }} </h5>
								<div class="d-flex flex-column">
									<h4> {{ Carbon\Carbon::parse($detail->tanggal_booking)->format('d F Y') }} </h4>
									<h4> {{ $detail->jam_booking }} </h4>
								</div>
							</div>
							<div class="col-md-6">
								<h4 class="d-flex justify-content-end font-weight-bold"> RP. {{ number_format($detail->harga , 0, ',', '.') }} </h4>
							</div>
						</div>
					</div>
					@endforeach
					@endif
				</div>
			</div>
		</div>
	</div>
	<!-- End Detail Booking -->

	<!-- Modal Bukti -->
	<div wire:ignore.self class="modal fade" id="seeBukti" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" style="width: fit-content; margin: 2em auto;">
			<div class="modal-content">														
				<div class="modal-body d-flex flex-column">
					<button type="button" class="close mb-3 ml-auto" data-dismiss="modal" aria-label="Close">
						<svg style="height: 24px; width: 24px;" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
					</button>
					
					<img src="{{ $bukti ? asset('storage/bukti_pembayaran/'. $bukti) : asset('images/empty.jpg') }}" style="max-height: 550px; width: 100%;">
				</div>
			</div>
		</div>
	</div>
	<!-- End Modal Bukti -->
</div>
