<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<title>Fithall</title>

	@livewireStyles
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
  {{-- <link href="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">   --}}

  <link rel="stylesheet" href="{{ asset('css/full-navbar.css') }}">
  <link rel="stylesheet" href="{{ asset('css/image-filter.css') }}">

  <link rel="icon" href="{{ asset('images/favico.png') }}">

  @yield('css')
</head>
<body>
  {{-- Header --}}
  @yield('header-menu')  
  {{-- End Header --}}

  <main role="main">
    @yield('content')
    {{isset($slot) ? $slot : null}}

    {{-- Footer --}}
    @yield('footer')
    {{-- End Footer --}}

    {{-- Modal Peraturan --}}
    <div wire:ignore.self class="modal fade" id="panduanPenggunaan" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="searchPembayaran" aria-hidden="true">
      <div class="modal-dialog modal-fullscreen modal-dialog-scrollable">
        <div class="modal-content">
          <div class="modal-header nav-bg text-white px-4">
            <h5 class="modal-title text-uppercase" id="exampleModalToggleLabel">Cara Booking & Tata Tertib</h5>
            <button type="button" class="bg-white p-2 btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <div class="container py-3">
              <div class="mb-5">
                <center>
                  <h4 class="text-uppercase border-bottom border-dark pb-2 mb-3" >CARA BOOKING BADMINTON FITHALL</h4>
                </center>

                <div class="d-block d-md-flex align-items-center">
                  <div>
                    <h5 class="mb-2">
                      <div class="d-flex">
                        <span class="me-2"><b> 1. </b></span>
                        Masuk ke web kami untuk jadwal yang ter-update
                      </div>
                      <div class="mt-2">
                        <a href="http://berkah-fithall.ip-dynamic.com " class=" ms-4"> 
                          http://berkah-fithall.ip-dynamic.com 
                        </a>
                      </div>
                    </h5>

                    <h5 class="mt-4"> 2. Melalui WhatsApp ke : 
                      <a href="https://wa.me/+62811105841?text=Halo%20Fithall!" class="ms-1 text-success text-decoration-none"> 0811.105.841 </a>
                    </h5>
                  </div>
                  <div style="background: #1c8751;" class="mt-3 mt-md-0 py-4 px-2 ms-auto">
                    <center>
                      <img src="{{ asset('images/logo.png') }}" style="height: 65px; width: auto;">
                    </center>
                  </div>
                </div>
              </div>

              <div>
                <center>
                  <h4 class="text-uppercase border-bottom border-dark pb-2 mb-3" >TATA TERTIB BADMINTON FITHALL</h4>
                </center>

                <div>
                  <h5 class="fw-bold d-flex align-items-center mb-3 mb-md-2"> <span class="d-none d-md-flex" style="font-size: 35px; margin: -8px .4em 0 0;"> &rarr; </span> Ketentuan Waktu dan Pembayaran </h5>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 1. </b></span>
                    Pembayaran lapangan dilakukan paling lambat 2 x 60 menit (2 jam) setelah reservasi
                    dilakukan, min DP 50%. Jika lebih dari 2 x 60 menit tidak ada pembayaran, maka
                    reservasi akan batal otomatis tanpa perlu ada konfirmasi dari pihak Badminton Fithall  
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 2. </b></span>
                    Penyewa diwajibkan hadir tepat waktu sesuai jadwal
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 3. </b></span>
                    Pengguna lapangan tidak boleh melebihi batas waktu
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 4. </b></span>
                    Perpanjangan waktu diperbolehkan selama ada jam kosong berikutnya
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 5. </b></span>
                    Apabila penyewa tidak hadir pada hari dan jam yang telah terjadwal, tidak ada pergantian waktu dan uang
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 6. </b></span>
                    Penyewa bersedia dipindahjadwalkan ke hari dan jam yang lain apabila lapangan akan digunakan untuk Tournament atau acara lainnya
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 7. </b></span>
                    Operational Fithall tetap buka pada hari libur nasional (tanggal merah), kecuali hari raya Idul Fitri, Idul Adha. Oleh sebab itu, Member Fithall yang terjadwal tepat pada hari merah tidak dapat dipindah jadwalkan, dan tetap dihitung sebagai jadwal main
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 8. </b></span>
                    Lampu yang digunakan/dinyalakan sesuai dengan lapangan yang di sewa
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 9. </b></span>
                    Setiap member wajib membayar sebelum jadwal main habis, dan dibayarkan untuk 1 bulan penuh sewa sesuai hari dan jam main tanpa terkecuali. Jika tidak dibayarkan, pihak Fithall berhak mengubah jadwal tersebut
                  </div>
                  
                </div>

                <div>
                  <h5 class="fw-bold d-flex align-items-center mb-3 mb-md-2"> <span class="d-none d-md-flex" style="font-size: 35px; margin: -8px .4em 0 0;"> &rarr; </span> Ketentuan Pakaian & Peralatan </h5>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 1. </b></span>
                    Penyewa wajib menggunakan sepatu badminton (non marker sole). Jika tidak menggunakan sepatu badminton, wajib menyewa sepatu di manajemen Fithall badminton sebesar Rp 15.000/jam
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 2. </b></span>
                    Penyewa wajib menggunakan pakaian olahraga
                  </div>
                  
                </div>

                <div>
                  <h5 class="fw-bold d-flex align-items-center mb-3 mb-md-2"> <span class="d-none d-md-flex" style="font-size: 35px; margin: -8px .4em 0 0;"> &rarr; </span> Kewajiban & Tanggung jawab Penyewa </h5>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 1. </b></span>
                    Penyewa tidak mengganggu penyewa lainnya
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 2. </b></span>
                    Penyewa wajib ikut serta dalam memelihara kebersihan, kenyamanan dan keamanan bersama
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 2. </b></span>
                    Manajemen tidak bertanggung jawab atas kehilangan maupun kerusakan barangbarang milik penyewa
                  </div>
                  <div class="d-flex mb-2 ms-md-5">
                    <span class="me-3"><b> 2. </b></span>
                    Manajemen tidak bertanggung jawab atas kondisi kesehatan dan keselamatan jiwa penyewa
                  </div>
                  
                </div>
              </div>              
            </div>
          </div>
          <div class="modal-footer">
            <i>Kerjasama dan Masukan membangun silahkan hub 
              <a href="https://wa.me/+628129613430?text=Halo,%20saya%20..." class="fw-bold text-decoration-none"> +62.812.961.3430 </a>
            </i>
          </div>
        </div>
      </div>
    </div>
    {{-- End Modal Peraturan --}}    

  </main>  

  @livewireScripts
  <script src="{{ asset('Dashboard/js/core/jquery.3.2.1.min.js') }}"></script>
  {{-- <script src="{{ asset('Dashboard/js/core/popper.min.js') }}"></script>
  <script src="{{ asset('Dashboard/js/core/bootstrap.min.js') }}"></script> --}}
  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js" integrity="sha384-7+zCNj/IqJ95wo16oMtfsKbZ9ccEh31eOz1HGyDuCQ6wgnyJNSYdrPa03rtR1zdB" crossorigin="anonymous"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js" integrity="sha384-QJHtvGhmr9XOIpI6YVutG+2QOK9T+ZnN4kzFN1RtK3zEFEIsxhlmWl5/YESvpZ13" crossorigin="anonymous"></script>  
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.css" />
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.isotope/3.0.6/isotope.pkgd.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.js"></script>
  <script src="{{ asset('js/full-navbar.js') }}"></script>
  <script src="{{ asset('js/image-filter.js') }}"></script>

  <script>
    window.livewire.on('dataAdded',()=>{
      $('#addData').modal('hide');
    });	    
    window.livewire.on('dataNotFound',()=>{
      $('#searchPembayaran').modal('hide');
    });	    
  </script>

  @yield('js')
</body>
</html>
