<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMemberDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('member_id')->references('id')->on('members')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('lapangan_id')->references('id')->on('lapangan')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('transaksi_member_id')->references('id')->on('transaksi_member')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->integer('tahun');
            $table->string('bulan');
            $table->string('jam_booking');
            $table->integer('harga');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_details');
    }
}
