<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransaksiLapanganDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaksi_lapangan_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lapangan_id')->references('id')->on('lapangan')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('transaksi_lapangan_id')->references('id')->on('transaksi_lapangan')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->datetime('tanggal_booking');
            $table->string('jam_booking');
            $table->integer('harga');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaksi_lapangan_details');
    }
}
