<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransaksiLapangansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaksi_lapangan', function (Blueprint $table) {
            $table->id();
            $table->string('kode_transaksi');
            $table->string('kode_lapangan');
            $table->string('nama');
            $table->bigInteger('telepon');
            $table->text('alamat');
            $table->string('email');
            $table->integer('total_biaya');
            $table->enum('status', ['lunas', 'belum_bayar', 'member', 'tidak_valid', 'down_payment']);
            $table->integer('down_payment')->nullable();
            $table->string('bukti_transaksi')->nullable();
            $table->string('tambahan')->nullable();
            $table->datetime('tanggal_bayar')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaksi_lapangan');
    }
}
