<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaketLapangansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('paket_lapangan', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lapangan_id')->references('id')->on('lapangan')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('kode_paket');
            $table->string('jam');
            $table->integer('harga');
            $table->enum('weekend', ['yes', 'no']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('paket_lapangan');
    }
}
