<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransaksiMembersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaksi_member', function (Blueprint $table) {
            $table->id();
            $table->foreignId('member_id')->references('id')->on('members')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->integer('total_biaya');
            $table->string('bukti_transaksi')->nullable();
            $table->enum('status_bayar', ['belum_bayar', 'lunas']);
            $table->datetime('tanggal_bayar')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaksi_member');
    }
}
