<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMembersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('members', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->bigInteger('telepon');
            $table->text('alamat');
            $table->string('email');
            $table->enum('status', ['active', 'expired', 'belum_bayar'])->nullable();
            $table->enum('status_bayar', ['belum_bayar', 'lunas', 'sudah_bayar']);
            $table->integer('tahun');
            $table->string('bulan');
            $table->string('hari');
            $table->datetime('tanggal_aktif')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('members');
    }
}
