<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\TransaksiLapangan;

class TransaksiSukses extends Component
{
	public $transaksi, $cabang;

	public function mount($kode_transaksi,  $branch)
	{
		$this->cabang = $branch;
		$this->changeDB();

		$this->transaksi = TransaksiLapangan::where('kode_transaksi', $kode_transaksi)->first();		
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		return view('livewire.transaksi-sukses');
	}
}
