<?php

namespace App\Http\Livewire;

use Carbon\Carbon;

use App\Models\Member;
use Livewire\Component;

use App\Models\MemberDetail;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Storage;

use Illuminate\Contracts\Encryption\DecryptException;
use App\Models\TransaksiMember as TransaksiMemberModel;

class TransaksiMember extends Component
{	
	use WithFileUploads;

	public $harga, $photo, $phone, $atas_nama, $bank, $rekening, $kode_lapangan;
	public $member, $transaksi, $jumlahHari, $cabang;

	public function mount($telepon, $kodeLapangan, $branch)
	{
		$this->cabang = $branch;
		$this->changeDB();
		
		$this->phone = $telepon;
		$this->phone = Crypt::decryptString($this->phone);

		$this->kode_lapangan = $kodeLapangan;

		$this->atas_nama = 'ADE PAIZAH';
		$this->bank = 'images/icon/BCA.png';
		$this->rekening = '552 027 3001';

		$this->member = Member::where([['telepon', $this->phone], ['kode_lapangan', $this->kode_lapangan], ['status', 'belum_bayar']])->first();
		
		$this->memberDetail = MemberDetail::where('member_id', $this->member->id)->get();

		$this->transaksi = TransaksiMemberModel::where('member_id', $this->member->id)->orderBy('created_at', 'DESC')->first();

		$this->harga = $this->transaksi->total_biaya;
		$this->jumlahHari = $this->harga / $this->memberDetail->sum('harga');
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		return view('livewire.transaksi-member');
	}

	public function store()
	{
		$this->changeDB();

		$tanggal_bayar = Carbon::now()->locale('id');
		$tanggal_bayar->settings(['formatFunction' => 'translatedFormat']);

		if($this->transaksi)
		{		
			$this->validate([
				'photo' => 'image|max:2048|required',
			]);

			$imageName = md5($this->photo.microtime().'.'.$this->photo->extension());

			Storage::putFileAs(
				'public/bukti_pembayaran', $this->photo, $imageName
			);

			$this->transaksi->update([
				'bukti_transaksi' => $imageName,
				'tanggal_bayar' => $tanggal_bayar->format('Y-m-d H:i:s'),
			]);

			$this->member->update([
				'status_bayar' => 'sudah_bayar'
			]);

			$this->resetInput();

			return redirect()->route('send-mail-member', ['branch' => $this->cabang, 'memberId' => $this->member]);			
		}
	}

	public function resetInput()
	{
		$this->total_biaya = '';
		$this->phone = '';
		$this->bukti_transaksi = '';
	}
}
