<?php

namespace App\Http\Livewire;

use Carbon\Carbon;

use App\Mail\NotificationMail;
use Livewire\Component;
use Livewire\WithFileUploads;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Storage;
use Illuminate\Contracts\Encryption\DecryptException;

use App\Models\Member;
use App\Models\Lapangan;
use App\Models\TransaksiLapanganDetail;
use App\Models\TransaksiLapangan as TransaksiLapanganModels;

class TransaksiLapangan extends Component
{
	use WithFileUploads;

	public $photo, $harga, $status, $tambahan, $price_tambahan, $is_member;
	public $bank, $rekening, $atas_nama;
	public $telepon, $kode_transaksi, $transDetail, $cabang;
	public $email;

	public function mount($konfirmasi, $telepon, $branch)
	{
		$this->cabang = $branch;
		$this->changeDB();

		$this->kode_transaksi = $konfirmasi;
		$this->kode_transaksi = Crypt::decryptString($this->kode_transaksi);

		$this->telepon = $telepon;
		$this->telepon = Crypt::decryptString($this->telepon);
		
		$trans = TransaksiLapanganModels::where('kode_transaksi', $this->kode_transaksi)->first();

		$this->email = $trans;

		$this->transDetail = TransaksiLapanganDetail::where('transaksi_lapangan_id', $trans->id)->get();

		$tambahan = $trans->tambahan;
		$this->harga = $trans->total_biaya;
		$this->price_tambahan = $this->harga - $this->transDetail->sum('harga');

		$det = TransaksiLapanganDetail::where('transaksi_lapangan_id', $trans->id)->first();		

		$hari = Carbon::parse($det->tanggal_booking)->locale('id')->settings(['formatFunction' => 'translatedFormat'])->format('l'); 

		$lapangan = Lapangan::where('id', $det->lapangan_id)->first();

		// if($lapangan)
		// {
		// 	$member = Member::where([
		// 	['kode_lapangan', $lapangan->kode_lapangan],
		// 	['tahun', Carbon::parse($det->tanggal_booking)->format('Y')],
		// 	['bulan', Carbon::parse($det->tanggal_booking)->format('F')],
		// 	['hari', $hari],
		// 	['telepon', $this->telepon],
		// 	['status', 'active']
		// 	])->first();
		// }
		
		$this->is_member = 'no';

		if($trans->status == 'member')
		{
			$this->is_member = 'yes';

			// $this->status = $member->status;
			// if($this->status == 'active')
			// {
			// }
		}		

		$this->atas_nama = 'ADE PAIZAH';
		$this->bank = 'images/icon/BCA.png';
		$this->rekening = '552 027 3001';
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
			return view('livewire.transaksi-lapangan');
	}

	public function store()
	{		
		$this->changeDB();		
	
		$tanggal_bayar = Carbon::now()->locale('id');
		$tanggal_bayar->settings(['formatFunction' => 'translatedFormat']);

		$this->validate([
			'photo' => 'required',
		]);

		$transaksi = TransaksiLapanganModels::where([['telepon', $this->telepon], ['status', 'belum_bayar']])->first();

		$imageName = md5($this->photo.microtime().'.'.$this->photo->extension());

		Storage::putFileAs(
			'public/bukti_pembayaran', $this->photo, $imageName
		);

		if($transaksi)
		{							
			$transaksi->update([
				'bukti_transaksi' => $imageName,
				'tanggal_bayar' => $tanggal_bayar->format('Y-m-d H:i:s')
			]);
		}		

		$confirm = Crypt::encryptString($this->kode_transaksi);

		return redirect()->route('send-mail', ['branch' => $this->cabang, 'konfirmasi' => $confirm]);
	}
}
