<?php

namespace App\Http\Livewire;

use Carbon\Carbon;

use App\Models\Member;
use Livewire\Component;
use Illuminate\Support\Facades\Mail;
use App\Mail\MemberNotificationMail;

use App\Models\TransaksiMember as TransaksiMemberModel;

class SendMailMember extends Component
{
	public $cabang, $member, $transaksiMember, $details;

	public function mount($memberId, $branch)
	{
		$this->cabang = $branch;
		$this->changeDB();		

		$mems = Member::where('id', $memberId)->first();
		$this->member = $mems;

		$transMem = TransaksiMemberModel::where('member_id', $this->member->id)->first();
		$this->transaksiMember = $transMem;
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		$details = [
			'cabang' => $this->cabang,
			'nama' => $this->member->nama,
			'telepon' => $this->member->telepon,
			'tahun' => $this->member->tahun,
			'bulan' => $this->member->bulan,
			'hari' => $this->member->hari,
			'total_biaya' => 'RP.'.number_format($this->transaksiMember->total_biaya , 0, ',', '.'),
			'tanggal_bayar' => Carbon::parse($this->transaksiMember->tanggal_bayar)->format('d-m-Y'),
			'link' => 'http://berkah-fithall.ip-dynamic.com/'.$this->cabang.'/login',
		];

		if ($this->cabang == 'mampang')
		{
			$email = 'fithallmampang@gmail.com';
		}
		elseif ($this->cabang == 'kalibata')
		{
			$email = 'fithallkalibata@gmail.com';
		}
		
		Mail::to($email)->send(new MemberNotificationMail($details));		
			
		session()->flash('info-success', 'Bukti pembayaran telah terkirim, admin akan memverifikasi bukti tersebut');

		return view('livewire.pilih-cabang');

		// return view('');
	}
}
