<?php

namespace App\Http\Livewire;

use Carbon\Carbon;

use Livewire\Component;
use App\Mail\NotificationMail;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Crypt;
use App\Models\TransaksiLapanganDetail;
use App\Models\TransaksiLapangan as TransaksiLapanganModels;

class SendMail extends Component
{
	public $cabang, $kode_transaksi, $email, $details;

	public function mount($konfirmasi, $branch)
	{
		$this->cabang = $branch;
		$this->changeDB();

		$this->kode_transaksi = $konfirmasi;
		$this->kode_transaksi = Crypt::decryptString($this->kode_transaksi);

		$trans = TransaksiLapanganModels::where('kode_transaksi', $this->kode_transaksi)->first();
		$this->email = $trans;
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		$details = [
			'cabang' => $this->cabang,
			'nama' => $this->email->nama,
			'telepon' => $this->email->telepon,
			'total_biaya' => 'RP.'.number_format($this->email->total_biaya , 0, ',', '.'),
			'tanggal_bayar' => Carbon::parse($this->email->tanggal_bayar)->format('d-m-Y'),
			'link' => 'http://berkah-fithall.ip-dynamic.com/'.$this->cabang.'/login',
		];

		if ($this->cabang == 'mampang')
		{
			$email = 'fithallmampang@gmail.com';
		}
		elseif ($this->cabang == 'kalibata')
		{
			$email = 'fithallkalibata@gmail.com';
		}
		
		Mail::to($email)->send(new NotificationMail($details));		

		// return redirect()->route('transaksi.sukses', ['branch' => $this->cabang, 'kode_transaksi' => $this->kode_transaksi]);

		return view('livewire.redirect')->layout('layouts.plain');
	}
}
