<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Hash;

use App\Models\User;

class Register extends Component
{
	use WithPagination;
	protected $paginationTheme = 'bootstrap';

	public $selected_user, $cabang;
	public $name, $email, $role, $telepon, $password;

	public function mount($branch)
	{
		$this->cabang = $branch;
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		$this->changeDB();

		$users = User::orderBy('created_at', 'DESC')->paginate(10);
		return view('livewire.register', compact('users'))->layout('layouts.dashboard');
	}

	public function action($id)
	{
		if($this->selected_user == $id)		
		{
			$this->selected_user = '';
		}
		elseif(!$this->selected_user)
		{
			$this->selected_user = $id;
		}
		elseif($this->selected_user and $this->selected_user != $id)
		{
			$this->selected_user = $id;
		}
	}

	public function edit($id)
	{
		$this->changeDB();

		$user = User::where('id', $id)->first();
		$this->name = $user->name;
		$this->email = $user->email;
		$this->role = $user->role;
		$this->telepon = $user->telepon;
	}

	public function resetinput()
	{
		$name = '';
		$email = '';
		$role = '';
		$telepon = '';
		$password = '';
		$selected_user = '';
	}

	public function store()
	{
		$this->changeDB();

		$this->validate([
			'name' => 'required',
			'email' => 'required|unique:users|email',
			'password' => 'required',
			'telepon' => 'required',
			'role' => 'required',
		]);

		$user = User::create([
			'name' => $this->name,
			'email' => $this->email,
			'password' => Hash::make($this->password),
			'telepon' => $this->telepon,
			'role' => $this->role,
		]);

		$user->attachRole($this->role);

		session()->flash('info-success', 'Data User Berhasil Ditambahkan !');
		$this->resetinput();
		$this->emit('dataAdded');
	}

	public function update()
	{
		$this->changeDB();

		if($this->selected_user)
		{
			$this->validate([
				'name' => 'required',
				'email' => 'required|email',
				'password' => 'required',
				'telepon' => 'required',
				'role' => 'required',
			]);

			$user = User::find($this->selected_user);
			$user->update([
				'name' => $this->name,
				'email' => $this->email,
				'password' => Hash::make($this->password),
				'telepon' => $this->telepon
			]);

			session()->flash('info-success', 'Data User Berhasil Diupdate !');

			$this->resetinput();
			$this->emit('dataUpdated');
		}
	}	

	public function destroy()
	{
		$this->changeDB();

		if($this->selected_user)
		{
			$user = User::where('id', $this->selected_user)->delete();

			session()->flash('info-success', 'Data User Terhapus !');

			$this->resetinput();
			$this->emit('dataDeleted');
		}
	}
}
