<?php

namespace App\Http\Livewire;

use App\Models\Lapangan;
use App\Models\PaketLapangan;

use Livewire\WithPagination;
use Livewire\Component;

class PaketLapanganAdmin extends Component
{
	use WithPagination;
	protected $paginationTheme = 'bootstrap';

	public $lapangan_id, $nama_lapangan, $nomor_lapangan, $kode_paket, $jam, $harga, $weekend;
	public $selected_paket, $filter_lapangan, $filter_hari;
	public $kode_lapangan, $cabang;

	public function mount($branch)
	{
		$this->cabang = $branch;
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		$this->changeDB();

		$this->kode_lapangan = Lapangan::all();
		// dd($this->kode_lapangan);

		if($this->filter_lapangan)
		{
			if($this->filter_hari)
			{
				$pakets = PaketLapangan::where([
				['lapangan_id', $this->filter_lapangan], 
				['weekend', $this->filter_hari]])
				->paginate(10)->onEachSide(0);	
			}
			else
			{
				$pakets = PaketLapangan::where('lapangan_id', $this->filter_lapangan)->paginate(10)->onEachSide(0);
			}

			$fields = Lapangan::all();
			return view('livewire.paket-lapangan-admin', compact('pakets','fields'))->layout('layouts.dashboard');			
		}
		else
		{
			if($this->filter_hari)
			{
				$pakets = PaketLapangan::where('weekend', $this->filter_hari)->paginate(10)->onEachSide(0);
			}
			else
			{
				$pakets = PaketLapangan::paginate(10)->onEachSide(0);
			}

			$fields = Lapangan::all();
			return view('livewire.paket-lapangan-admin', compact('pakets','fields'))->layout('layouts.dashboard');
		}		
	}

	public function action($id)
	{
		if($this->selected_paket == $id)		
		{
			$this->selected_paket = '';
		}
		elseif(!$this->selected_paket)
		{
			$this->selected_paket = $id;
		}
		elseif($this->selected_paket and $this->selected_paket != $id)
		{
			$this->selected_paket = $id;
		}
	}

	public function resetSearch()
	{
		$this->searchTerm = '';
	}

	public function store()
	{
		$this->changeDB();

		$this->validate([
			'lapangan_id' => 'required',
			'kode_paket' => 'required',
			'jam' => 'required',
			'weekend' => 'required',
			'harga' => 'required',
		]);

		PaketLapangan::create([
			'lapangan_id' => $this->lapangan_id,
			'kode_paket' => $this->kode_paket,
			'jam' => $this->jam,
			'weekend' => $this->weekend,
			'harga' => $this->harga,
		]);

		session()->flash('info-success', 'Data Paket Berhasil Ditambahkan !');
		$this->resetinput();
		$this->emit('dataAdded');
	}

	public function edit($id)
	{
		$this->changeDB();

		$paket = PaketLapangan::where('id', $id)->first();
		$this->lapangan_id = $paket->lapangan_id;
		$this->nama_lapangan = $paket->lapangan->nama_lapangan;
		$this->nomor_lapangan = $paket->lapangan->nomor_lapangan;
		$this->kode_paket = $paket->kode_paket;
		$this->jam = $paket->jam;
		$this->weekend = $paket->weekend;
		$this->harga = $paket->harga;
	}

	public function resetInput()
	{
		$this->selected_paket = null;
		$this->lapangan_id = null;
		$this->nama_lapangan = null;
		$this->nomor_lapangan = null;
		$this->kode_paket = null;
		$this->jam = null;
		$this->weekend = null;
		$this->harga = null;
	}

	public function update()
	{
		$this->changeDB();

		if($this->selected_paket)
		{
			$this->validate([
				'lapangan_id' => 'required',
				'kode_paket' => 'required',
				'jam' => 'required',
				'weekend' => 'required',
				'harga' => 'required',				
			]);

			$paket = PaketLapangan::find($this->selected_paket);
			$paket->update([
				'lapangan_id' => $this->lapangan_id,
				'kode_paket' => $this->kode_paket,
				'jam' => $this->jam,
				'weekend' => $this->weekend,
				'harga' => $this->harga,				
			]);

			session()->flash('info-success', 'Data Paket Berhasil Diupdate !');

			$this->resetinput();
			$this->emit('dataUpdated');
		}
	}

	public function destroy($id)
	{
		$this->changeDB();

		if($id)
		{
			PaketLapangan::where('id', $id)->delete();
			session()->flash('info-success', 'Data Paket Terhapus !');

			$this->resetinput();
			$this->emit('dataDeleted');
		}
	}
}
