<?php

namespace App\Http\Livewire;

use Carbon\Carbon;

use App\Models\Member;
use App\Models\MemberDetail;
use App\Helpers\Helper;

use Livewire\Component;

use Carbon\CarbonPeriod;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Contracts\Encryption\DecryptException;

use App\Models\Gallery;
use App\Models\Lapangan;
use App\Models\TransaksiLapangan;
use App\Models\TransaksiLapanganDetail;
use App\Models\PaketLapangan as PaketLapanganModels;

class PaketLapangan extends Component
{
	public $kategori, $no_lapangan, $kode_lapangan;
	public $field, $booked_field, $pakets, $galleries;
	public $tanggal_booking, $now, $today;
	public $nama, $telepon, $alamat, $email, $kode_transaksi, $total_biaya, $discount;
	public $bookers, $AirConditioner, $ac_price;
	public $start, $booked_tgl, $cabang;

	public Collection $selectedPaket;

	public Collection $getPaket;

	public Collection $pack;	

	public function mount($jenisLapangan, $noLapangan, $kodeLapangan, $branch)
	{
		$this->cabang = $branch;
		$this->kategori = $jenisLapangan;
		$this->no_lapangan = $noLapangan;
		$this->kode_lapangan = $kodeLapangan;

		$this->changeDB();
		
		$this->reloadData();
		$this->checkPaidStatus();
		$this->getGalleries();
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{		
		$this->changeDB();

		$this->getDate();			
		
		$this->getPaket =  PaketLapanganModels::query()
		->whereIn('id', $this->selectedPaket->filter(fn($pket) => $pket)->keys()->toArray())
		->get();	

		$this->total_biaya = $this->getPaket->sum('harga');
		if($this->AirConditioner == 'yes')
		{
			$this->ac_price = $this->getPaket->count() * 10000;
			$this->total_biaya = $this->total_biaya + $this->ac_price;
		}
				
		$lapangan = Lapangan::where('kode_lapangan', $this->kode_lapangan)->first();

		$this->field = Lapangan::where([
		['kategori', $this->kategori], 
		['nomor_lapangan', $this->no_lapangan],
		['kode_lapangan', $this->kode_lapangan]])
		->first();

		$this->isWeekend();

		$this->booked_field = TransaksiLapanganDetail::where([
		['tanggal_booking', $this->booked_tgl],
		['lapangan_id', $lapangan->id]
		])->get();		

		return view('livewire.paket-lapangan');
	}

	public function reloadData()
	{
		$this->selectedCategory = null;
		$this->pack = PaketLapanganModels::get();
		$this->selectedPaket = $this->pack
		->map(fn($pket) => $pket->id)
		->flip()
		->map(fn($pket) => false);
	}

	// private function getSelectedHours()
	// {
	// 	return $this->selectedPaket->filter(fn($p) => $p)->keys();
	// }

	public function isWeekend()
	{		
		$dt = $this->now;
		$dt1 = strtotime($dt);
		$dt2 = date("l", $dt1);
		$dt3 = strtolower($dt2);

		if(($dt3 == "saturday") || ($dt3 == "sunday"))
		{
			$this->pakets = PaketLapanganModels::where([
			['lapangan_id', $this->field->id],
			['weekend', 'yes']])
			->get();
		}
		else
		{
			$this->pakets = PaketLapanganModels::where([
			['lapangan_id', $this->field->id],
			['weekend', 'no']])
			->get();
		}
	}

	public function getDate()
	{
		if(!$this->tanggal_booking)
		{
			$this->now = Carbon::now()->locale('id');
			$this->now->settings(['formatFunction' => 'translatedFormat']);
		}
		else
		{
			$this->now = $this->tanggal_booking;
			$this->now = Carbon::parse($this->now);
			$this->now = $this->now->locale('id');
			$this->now->settings(['formatFunction' => 'translatedFormat']);
		}

		$this->today = $this->now->format('l, d F Y');
		$this->booked_tgl = $this->now->format('Y-m-d');
	}

	public function store()
	{
		$dtes = $this->tanggal_booking;;
		$dtes = Carbon::parse($dtes);

		$hari = $dtes->locale('id');
		$hari->settings(['formatFunction' => 'translatedFormat']);
		$hari = $hari->format('l');
		
		$tahun = $dtes->format('Y');
		$bulan = $dtes->format('F');

		$this->changeDB();

		$this->validate([
			'nama' => 'required',
			'telepon' => 'required|min:10|max:15',
			'alamat' => 'required',
			'email' => 'required|email',
		]);

		$this->telepon = (int)'62'.$this->telepon;
		
		$q = new TransaksiLapangan;
		$this->kode_transaksi = Helper::IDGenerator($q, 'kode_transaksi', 2, ($this->now->format('Ym')));
		
		$lapangan = Lapangan::where('kode_lapangan', $this->kode_lapangan)->first();

		$tgl = $this->tanggal_booking;
		$tgl = Carbon::parse($tgl);		

		$is_member = Member::where([
		['kode_lapangan', $this->kode_lapangan],
		['telepon', $this->telepon],
		['status', 'active'], 
		['tahun', $tgl->format('Y')], 
		['bulan', $tgl->format('F')]
		])->first();		

		// $member = Member::where([['telepon', $this->telepon], ['status', 'active']])->first();

		if($is_member)
		{
			$memberDetail = MemberDetail::where('member_id', $is_member->id)->get();
		}

		$is_same_time = 'false';

		if($is_member)
		{
			foreach ($this->getPaket as $key => $value)
			{
				foreach ($memberDetail as $memKey => $memVa)
				{
					if($memberDetail[$memKey]['hari'] == $hari && $memberDetail[$memKey]['tahun'] == $tgl->format('Y') && $memberDetail[$memKey]['bulan'] == $tgl->format('F'))
					{
						if($memberDetail[$memKey]['jam_booking'] == $this->getPaket[$key]['jam'])
						{
							$is_same_time = 'true';
						}
					}
				}
			}
		}		
		
		$status_bayar = 'belum_bayar';
		
		if($is_member && $is_same_time == 'true')
		{
			$status_bayar = 'member';
		}

		$tambahan = '';
		if($this->AirConditioner == 'yes')
		{
			$tambahan = 'AC';
		}

		$saved = TransaksiLapangan::create([
			'kode_transaksi' => $this->kode_transaksi,
			'kode_lapangan' => $this->kode_lapangan,
			'nama' => $this->nama,
			'telepon' => $this->telepon,
			'alamat' => $this->alamat,
			'email' => $this->email,
			'total_biaya' => $this->total_biaya,
			'status' => $status_bayar,
			'tambahan' => $tambahan,
			'tanggal_booking' => $this->now->format('Y-m-d')
		]);

		foreach ($this->getPaket as $key => $value) 
		{
			if(!TransaksiLapanganDetail::where([
				['tanggal_booking', $this->now->format('Y-m-d')], 
				['jam_booking', $this->getPaket[$key]['jam']],
				['lapangan_id', $lapangan->id], 
				])->exists())
			{
				TransaksiLapanganDetail::insert([
					'transaksi_lapangan_id' => $saved->id,
					'lapangan_id' => $lapangan->id,
					'tanggal_booking' => $this->now->format('Y-m-d'),
					'jam_booking' => $this->getPaket[$key]['jam'],
					'harga' => $this->getPaket[$key]['harga'],
				]);		
			}
			else
			{	
				TransaksiLapangan::where('id', $saved->id)->delete();
				
				session()->flash('info-failed', 'Jadwal lapangan yang anda pilih sudah di booking oleh orang lain, silahkan lihat menu "Lapangan Terbooking" untuk melihat jadwal yang telah terbooking');

				return redirect()->route('paket.lapangan', ['branch' => $this->cabang, 'jenisLapangan' => $this->kategori, 'noLapangan' =>$this->no_lapangan, 'kodeLapangan' => $this->kode_lapangan]);
			}
		}		

		// dd($is_member);

		// if($is_member)
		// {
		// 	$mem_id = $is_member->id;
		// }
		// else
		// {
		// 	$mem_id = 0;
		// }


		$confirm = Crypt::encryptString($saved->kode_transaksi);
		$telepon = Crypt::encryptString($this->telepon);

		return redirect()->route('lapangan.transaksi', ['branch' => $this->cabang, 'konfirmasi' => $confirm, 'telepon' => $telepon]); 
	}

	public function checkPaidStatus()
	{		
		$this->changeDB();

		$now = Carbon::now()->locale('id');
		$now->settings(['formatFunction' => 'translatedFormat']);		

		$this->bookers = TransaksiLapangan::where('status', 'belum_bayar')->orWhere('status', 'tidak_valid')->get();
		
		foreach ($this->bookers as $key => $value) 
		{
			if(!$this->bookers[$key]['bukti_transaksi'])
			{
				$booked_at = $this->bookers[$key]['created_at'];
				$expired = $this->bookers[$key]['created_at']->addMinutes(120);

				if($expired->format('Y-m-d H:i') <= $now->format('Y-m-d H:i'))
				{
					$this->bookers[$key]->delete();
				}
			}
			if($this->bookers[$key]['status'] == 'tidak_valid')
			{
				$this->bookers[$key]->delete();
			}
		}
	}

	public function getGalleries()
	{
		$lapangan = Lapangan::where('kode_lapangan', $this->kode_lapangan)->first();
		$this->galleries = Gallery::where('lapangan_id', $lapangan->id)->get();
	}
}
