<?php

namespace App\Http\Livewire;

use Carbon\Carbon;

use Livewire\Component;
use Livewire\WithPagination;

use App\Models\TransaksiMember;
use App\Models\Member;
use App\Models\MemberDetail;

class MemberAdmin extends Component
{
	use WithPagination;
	protected $paginationTheme = 'bootstrap';

	public $selected_member, $status, $stat, $bukti, $down_payment;
	public $searchTerm, $memberDetails, $cabang;

	public function mount($branch)
	{		
		$this->cabang = $branch;
		$this->changeDB();
		$this->checkPaidStatus();
		$this->checkMemberExpire();
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}	

	public function render()
	{
		$this->changeDB();

		$searchTerm = '%'.$this->searchTerm . '%';
		$members = Member::where('nama','LIKE',$searchTerm)
		->orWhere('telepon','LIKE',$searchTerm)
		->orWhere('status','LIKE',$searchTerm)
		->orderBy('created_at','DESC')
		->paginate(10);
		$trans = TransaksiMember::orderBy('created_at', 'DESC')->paginate(10);

		if($this->selected_member)
		{
			$this->memberDetails = MemberDetail::where('member_id', $this->selected_member)->get();
		}

		return view('livewire.member-admin', compact('members', 'trans'))->layout('layouts.dashboard');
	}

	public function resetSearch()
	{
		$this->searchTerm = '';
	}

	public function action($id)
	{
		if($this->selected_member == $id)		
		{
			$this->selected_member = '';
		}
		elseif(!$this->selected_member)
		{
			$this->selected_member = $id;
		}
		elseif($this->selected_member and $this->selected_member != $id)
		{
			$this->selected_member = $id;
		}
	}

	public function edit($id)
	{
		$this->changeDB();

		$member = Member::where('id', $this->selected_member)->first();
		$this->stat = $member->status;
		$this->status = $member->status;		
	}

	function update()
	{
		$this->changeDB();

		if($this->selected_member)
		{
			$tanggal_reg = Carbon::now()->locale('id');
			$tanggal_reg->settings(['formatFunction' => 'translatedFormat']);

			$dp = null;
			$status_bayar = 'sudah_bayar';

			if ($this->status == 'down_payment')
			{
				$dp = $this->down_payment;
			}

			$tgl_aktif = null;
			if ($this->status == 'active')
			{
				$tgl_aktif = $tanggal_reg->format('Y-m-d H:i:s');
				$status_bayar = 'lunas';
			}

			$member = Member::find($this->selected_member);
			$member->update([
				'status' => $this->status,
				'status_bayar' => $status_bayar,
				'down_payment' => $dp,
				'tanggal_aktif' => $tgl_aktif
			]);

			$transMember = TransaksiMember::where('member_id', $this->selected_member)->first();
			$transMember->update([
				'status_bayar' => 'lunas'
			]);

			session()->flash('info-success', 'Data Updated Successfully !');
			
			$this->selected_member = '';
			$this->status = '';
			$this->emit('dataUpdated');
		}
	}

	public function checkPaidStatus()
	{		
		$this->changeDB();

		$now = Carbon::now()->locale('id');
		$now->settings(['formatFunction' => 'translatedFormat']);		

		$this->bookers = Member::where([['status', 'belum_bayar'], ['status_bayar', 'belum_bayar']])
																->orWhere([['status', 'tidak_valid'], ['status_bayar', 'sudah_bayar']])->get();
		
		foreach ($this->bookers as $key => $value) 
		{
			if($this->bookers[$key]['status_bayar'] == 'belum_bayar')
			{
				$booked_at = $this->bookers[$key]['created_at'];
				$expired = $this->bookers[$key]['created_at']->addMinutes(120);

				if($expired->format('Y-m-d H:i') <= $now->format('Y-m-d H:i'))
				{
					$this->bookers[$key]->delete();
				}
			}
			if($this->bookers[$key]['status'] == 'tidak_valid')
			{
				$this->bookers[$key]->delete();
			}
		}
	}

	public function checkMemberExpire()
	{		
		$this->changeDB();
		
		$now = Carbon::now()->locale('id');
		$now->settings(['formatFunction' => 'translatedFormat']);		

		$mem = Member::where('status', 'active')->get();
		
		foreach ($mem as $key => $value) 
		{
			if($mem[$key]['status'] == 'active')
			{
				$member_at = Carbon::parse($mem[$key]['tanggal_aktif']);
				$expired_mem = $member_at->addMonths(1)->format('Y-m-d');

				if($now->format('Y-m-d') >= $expired_mem)
				{
					$mem[$key]->update([
						'status' => 'expired'
					]);
				}
			}
		}
	}

	public function detail($id)
	{
		$this->changeDB();

		$transe = TransaksiMember::where('member_id', $id)->first();
		$this->bukti = $transe->bukti_transaksi;
	}
}
