<?php

namespace App\Http\Livewire;

use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Contracts\Encryption\DecryptException;

use Livewire\Component;

use App\Models\HargaMember;
use App\Models\Member as MemberModel;
use App\Models\MemberDetail;
use App\Models\Lapangan;
use App\Models\PaketLapangan as PaketLapanganModels;
use App\Models\TransaksiMember as TransaksiMemberModel;

class Member extends Component
{
	public $nama, $telepon, $alamat, $email, $status, $durasi, $harga;
	public $tanggal_member, $selected_tanggal, $hari, $bulan, $tahun;
	public $jenis_lapangan, $nomor_lapangan, $daysCount, $period, $dates;
	public $pakets, $cabang;

	public Collection $selectedPaket;

	public Collection $getPaket;

	public Collection $pack;

	public function mount($branch)
	{
		$this->cabang = $branch;
		$this->reloadData();		
		$this->checkPaidStatus();
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function reloadData()
	{
		$this->changeDB();

		$this->selectedCategory = null;
		$this->pack = PaketLapanganModels::get();
		$this->selectedPaket = $this->pack
		->map(fn($pket) => $pket->id)
		->flip()
		->map(fn($pket) => false);
	}

	public function render()
	{
		$this->changeDB();

		$this->tanggal_member();
		$this->counting_days();
		$this->isWeekend();

		$no_lapangan = Lapangan::where('kategori', $this->jenis_lapangan)->get();

		$this->getPaket =  PaketLapanganModels::query()
		->whereIn('id', $this->selectedPaket->filter(fn($pket) => $pket)->keys()->toArray())
		->get();	

		$this->harga = HargaMember::where('status', 'active')->first();
		
		return view('livewire.member', compact('no_lapangan'));
	}

	public function isWeekend()
	{
		if($this->nomor_lapangan)
		{
			$this->field = Lapangan::where([
			['kategori', $this->jenis_lapangan], 
			['nomor_lapangan', $this->nomor_lapangan]])
			->first();

			if(($this->hari == "sabtu") || ($this->hari == "minggu"))
			{
				$this->pakets = PaketLapanganModels::where([
				['lapangan_id', $this->field->id],
				['weekend', 'yes']])
				->get();
			}
			else
			{
				$this->pakets = PaketLapanganModels::where([
				['lapangan_id', $this->field->id],
				['weekend', 'no']])
				->get();
			}		
		}
	}

	public function resetInput()
	{
		$this->nama = null;
		$this->telepon = null;
		$this->alamat = null;
		$this->email = null;
		$this->durasi = null;
	}

	public function store()
	{
		$this->changeDB();

		$this->validate([
			'tanggal_member' => 'required',
			'hari' => 'required',
			'jenis_lapangan' => 'required',
			'nomor_lapangan' => 'required',
			'nama' => 'required',
			'telepon' => 'required|unique:members|min:8|max:15',
			'alamat' => 'required'
		]);

		$price = $this->getPaket->sum('harga');
		$price = $price * $this->daysCount;
		$this->telepon = (int)'62'.$this->telepon;
		$bln = $this->selected_tanggal->format('Y-m-d');

		$lapangan = Lapangan::where([['kategori', $this->jenis_lapangan], ['nomor_lapangan', $this->nomor_lapangan]])->first();

		if(!MemberModel::where([
			['telepon', $this->telepon],
			['kode_lapangan', $lapangan->kode_lapangan],
			['email', $this->email],
			['status', 'active']
			])->exists())
		{	
			$member = MemberModel::create([
				'nama' => $this->nama,
				'telepon' => $this->telepon,
				'alamat' => $this->alamat,
				'email' => $this->email,
				'kode_lapangan' => $lapangan->kode_lapangan,
				'status' => 'belum_bayar',
				'status_bayar' => 'belum_bayar',
				'tahun' => $this->selected_tanggal->format('Y'),
				'bulan' => $this->selected_tanggal->format('F'),
				'hari' => $this->hari
			]);

			$transMem = TransaksiMemberModel::create([
				'member_id' => $member->id,
				'status_bayar' => 'belum_bayar',
				'total_biaya' => $price,
			]);			

			foreach ($this->getPaket as $key => $value) 
			{
				if(!MemberDetail::where([
					['lapangan_id', $lapangan->id], 
					['hari', $this->hari], 
					['bulan', $this->selected_tanggal->format('F')], 
					['tahun', $this->selected_tanggal->format('Y')], 
					['jam_booking', $this->getPaket[$key]['jam']]
					])->exists())
				{
					MemberDetail::insert([
						'transaksi_member_id' => $transMem->id,
						'member_id' => $member->id,
						'lapangan_id' => $lapangan->id,
						'tahun' => $this->selected_tanggal->format('Y'),
						'bulan' => $this->selected_tanggal->format('F'),
						'hari' => $this->hari,
						'jam_booking' => $this->getPaket[$key]['jam'],
						'harga' => $this->getPaket[$key]['harga'],
					]);		
				}		
				else
				{	
					MemberModel::where('id', $member->id)->delete();
					
					session()->flash('info-failed', 'Jadwal Member yang anda pilih sudah di dipilih oleh orang lain');
	
					return redirect()->route('member', ['branch' => $this->cabang]);
				}					
			}			
		}
	
		$telepon = $this->telepon;
		$telepon = Crypt::encryptString($telepon);

		return redirect()->route('member.transaksi', ['branch' => $this->cabang, 'telepon' => $telepon, 'kodeLapangan' => $lapangan->kode_lapangan]);	
	}

	public function checkPaidStatus()
	{		
		$this->changeDB();

		$now = Carbon::now()->locale('id');
		$now->settings(['formatFunction' => 'translatedFormat']);		

		$this->bookers = MemberModel::where([['status', 'belum_bayar'], ['status_bayar', 'belum_bayar']])
																->orWhere([['status', 'tidak_valid'], ['status_bayar', 'sudah_bayar']])->get();
		
		foreach ($this->bookers as $key => $value) 
		{
			if($this->bookers[$key]['status_bayar'] == 'belum_bayar')
			{
				$booked_at = $this->bookers[$key]['created_at'];
				$expired = $this->bookers[$key]['created_at']->addMinutes(120);

				if($expired->format('Y-m-d H:i') <= $now->format('Y-m-d H:i'))
				{
					$this->bookers[$key]->delete();
				}
			}
			if($this->bookers[$key]['status'] == 'tidak_valid')
			{
				$this->bookers[$key]->delete();
			}
		}
	}

	public function tanggal_member()
	{
		if($this->tanggal_member)
		{
			$this->selected_tanggal = $this->tanggal_member;
			$this->selected_tanggal = Carbon::parse($this->selected_tanggal);
			$this->selected_tanggal = $this->selected_tanggal->locale('id');
			$this->selected_tanggal->settings(['formatFunction' => 'translatedFormat']);
			$this->bulan = $this->selected_tanggal->format('F');
			$this->tahun = $this->selected_tanggal->format('Y');
		}
	}

	public function counting_days()
	{
		if($this->tanggal_member)
		{			
			if($this->hari)
			{
				$start = $this->tanggal_member;
				$start = Carbon::parse($start);

				$startOfMonth = $start->startOfMonth();

				$endOfMonth = $startOfMonth->copy()->endOfMonth();

				$this->daysCount = $startOfMonth->diffInDaysFiltered(function(Carbon $date) 
				{
					if($this->hari == 'Senin')
					{
						return $date->isMonday();
					}
			
					if($this->hari == 'Selasa')
					{
						return $date->isTuesday();
					}
			
					if($this->hari == 'Rabu')
					{
						return $date->isWednesday();
					}
			
					if($this->hari == 'Kamis')
					{
						return $date->isThursday();
					}
			
					if($this->hari == 'Jumat')
					{
						return $date->isFriday();
					}
			
					if($this->hari == 'Sabtu')
					{
						return $date->isSaturday();
					}
			
					if($this->hari == 'Minggu')
					{
						return $date->isSunday();
					}
				}, $endOfMonth);

				// dd($daysCount);
			}
		}
	}
}
