<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\TransaksiMember;

class LaporanTransaksiMember extends Component
{
	use WithPagination;
	protected $paginationTheme = 'bootstrap';

	public $bukti, $jumlah_transaksi, $jumlah_pemasukan;
	public $cabang;

	public function mount($branch)
	{
		$this->cabang = $branch;
	}	

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		$this->changeDB();

		$trans = TransaksiMember::where('status_bayar', 'lunas')->orderBy('created_at', 'DESC')->paginate(10);
		
		$this->jumlah_transaksi = count($trans);
		$this->jumlah_pemasukan = $trans->sum('total_biaya');

		return view('livewire.laporan-transaksi-member', compact('trans'))->layout('layouts.dashboard');
	}

	public function detail($id)
	{
		$this->changeDB();

		$transe = TransaksiMember::where('member_id', $id)->first();
		$this->bukti = $transe->bukti_transaksi;
	}
}
