<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\TransaksiLapangan;
use App\Models\TransaksiLapanganDetail;

class LaporanTransaksiLapangan extends Component
{
	public $jumlah_transaksi, $jumlah_pemasukan;
	public $bukti, $detail_transkasi, $cabang;

	public function mount($branch)
	{
		$this->cabang = $branch;
	}	

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		$this->changeDB();

		$trans = TransaksiLapangan::where('status', 'lunas')->orWhere('status', 'member')->paginate(10);

		$this->jumlah_transaksi = count($trans);
		$this->jumlah_pemasukan = $trans->sum('total_biaya');

		return view('livewire.laporan-transaksi-lapangan', compact('trans'))->layout('layouts.dashboard');
	}

	public function detail($id)
	{
		$this->changeDB();

		$transe = TransaksiLapangan::where('id', $id)->first();
		$this->bukti = $transe->bukti_transaksi;
	}

	public function detailTransaksi($id)
	{
		$this->changeDB();

		$this->detail_transkasi = TransaksiLapanganDetail::where('transaksi_lapangan_id', $id)->get();
	}
}
