<?php

namespace App\Http\Livewire;

use App\Models\Lapangan;

use Livewire\Component;
use Livewire\WithPagination;

class LapanganAdmin extends Component
{
	use WithPagination;
	protected $paginationTheme = 'bootstrap';

	public $kode_lapangan, $nama_lapangan, $ukuran_lapangan, $nomor_lapangan, $kategori, $confirm, $keterangan;
	public $selected_lapangan, $cabang;
	
	public function mount($branch)
	{
		$this->cabang = $branch;
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		$this->changeDB();
		
		$fields = Lapangan::orderBy('created_at', 'ASC')->paginate(10);
			
		return view('livewire.lapangan-admin', compact('fields'))->layout('layouts.dashboard');
	}

	public function action($id)
	{
		if($this->selected_lapangan == $id)		
		{
			$this->selected_lapangan = '';
		}
		elseif(!$this->selected_lapangan)
		{
			$this->selected_lapangan = $id;
		}
		elseif($this->selected_lapangan and $this->selected_lapangan != $id)
		{
			$this->selected_lapangan = $id;
		}
	}

	public function resetinput()
	{
		$this->kode_lapangan = null;
		$this->nama_lapangan = null;
		$this->nomor_lapangan = null;
		$this->ukuran_lapangan = null;
		$this->kategori = null;
		$this->keterangan = null;
		$this->confirm = null;
		$this->selected_lapangan = null;
	}

	public function store()
	{
		$this->changeDB();

		if($this->kategori == 'lainnya')
		{
			$this->kategori = $this->keterangan;
		}

		$this->validate([
			'kode_lapangan' => 'required',
			'nama_lapangan' => 'required',
			'nomor_lapangan' => 'required',
			'kategori' => 'required',
		]);

		Lapangan::create([
			'kode_lapangan' => $this->kode_lapangan,
			'nama_lapangan' => $this->nama_lapangan,
			'nomor_lapangan' => $this->nomor_lapangan,
			'ukuran_lapangan' => $this->ukuran_lapangan,
			'kategori' => $this->kategori,
		]);

		$this->resetinput();

		session()->flash('info-success', 'Data Lapangan Berhasil Ditambahkan !');
		$this->emit('dataAdded');
	}

	public function edit($id)
	{
		$this->changeDB();

		$field = Lapangan::where('id', $id)->first();
		$this->confirm = $field->nama_lapangan;
		$this->kode_lapangan = $field->kode_lapangan;
		$this->nama_lapangan = $field->nama_lapangan;
		$this->nomor_lapangan = $field->nomor_lapangan;
		$this->ukuran_lapangan = $field->ukuran_lapangan;
		$this->kategori = $field->kategori;
	}

	public function update()
	{
		$this->changeDB();

		if($this->selected_lapangan)
		{
			$this->validate([
				'kode_lapangan' => 'required',
				'nama_lapangan' => 'required',
				'nomor_lapangan' => 'required',
				'ukuran_lapangan' => 'required',
				'kategori' => 'required',
			]);

			$lap = Lapangan::find($this->selected_lapangan);
			$lap->update([
				'kode_lapangan' => $this->kode_lapangan,
				'nama_lapangan' => $this->nama_lapangan,
				'nomor_lapangan' => $this->nomor_lapangan,
				'ukuran_lapangan' => $this->ukuran_lapangan,
				'kategori' => $this->kategori,		
			]);

			session()->flash('info-success', 'Product Updated Successfully !');

			$this->resetinput();
			$this->emit('dataUpdated');
		}
	}

	public function destroy($id)
	{
		$this->changeDB();

		if($id)
		{
			Lapangan::where('id', $id)->delete();
			session()->flash('info-success', 'Data Lapangan Terhapus !');

			$this->resetinput();
			$this->emit('dataDeleted');
		}
	}	
}
