<?php

namespace App\Http\Livewire;

use Carbon\Carbon;
use Livewire\Component;

use App\Models\Lapangan as LapanganModels;

class Lapangan extends Component
{
	public $jenis_lapangan, $pickup_dates = [];
	public $cabang;

	public function mount($jenisLapangan, $branch)
	{
		$this->jenis_lapangan = $jenisLapangan;
		$this->cabang = $branch;
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{       
		$this->changeDB();

		$fields = LapanganModels::where('kategori', $this->jenis_lapangan)->get();
		return view('livewire.lapangan', compact('fields'));
	}
}
