<?php

namespace App\Http\Livewire;

use Livewire\Component;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;

use App\Models\Member;
use App\Models\Gallery;
use App\Models\Lapangan;
use App\Models\TransaksiLapangan;

class Home extends Component
{
	public $filter = 'all', $searchTransaksi;
	public $jenis_lapangan, $nomor_lapangan, $lapangan;
	public $cabang;

	public function mount($branch)
	{
		$this->cabang = $branch;
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		$this->changeDB();

		$fields = DB::table('lapangan')
							->select('kategori')
							->groupByRaw('kategori')
							->get(); 

		$no_lapangan = Lapangan::where('kategori', $this->jenis_lapangan)->get();
		$this->lapangan = Lapangan::where([['kategori', $this->jenis_lapangan], ['nomor_lapangan', $this->nomor_lapangan]])->first();

		$galleries = Gallery::orderBy('created_at', 'DESC')->get();

		return view('livewire.home', compact('galleries', 'fields', 'no_lapangan'));	
	}

	public function cariMember()
	{
		$this->changeDB();

		$this->searchTransaksi = (int)'62'.$this->searchTransaksi;
		$tlp = $this->searchTransaksi;

		$member = Member::where([
		['telepon', $this->searchTransaksi], 
		['kode_lapangan', $this->lapangan->kode_lapangan],
		['status', 'belum_bayar']
		])->orderBy('created_at', 'DESC')->first();

		if($member)
		{
			$telepon = $tlp;
			$telepon = Crypt::encryptString($telepon);
			return redirect()->route('member.transaksi', ['branch' => $this->cabang, 'telepon' => $telepon, 'kodeLapangan' => $this->lapangan->kode_lapangan]);
		}
		else
		{
			$this->notFound();
		}
	}

	public function cariBooking()
	{
		$this->changeDB();

		$this->searchTransaksi = (int)'62'.$this->searchTransaksi;
		$tlp = $this->searchTransaksi;

		$trans = TransaksiLapangan::where([
		['telepon', $this->searchTransaksi], 
		['status', 'belum_bayar'], 
		['kode_lapangan', $this->lapangan->kode_lapangan]
		])->orWhere([
		['telepon', $this->searchTransaksi], 
		['status', 'member'],
		['kode_lapangan', $this->lapangan->kode_lapangan]
		])->orderBy('created_at', 'DESC')->first();
		
		if($trans)
		{
			$confirm = $trans->kode_transaksi;
			$confirm = Crypt::encryptString($confirm);

			$telepon = $tlp;
			$telepon = Crypt::encryptString($telepon);

			return redirect()->route('lapangan.transaksi', ['branch' => $this->cabang, 'konfirmasi' => $confirm, 'telepon' => $telepon]); 
		}
		else
		{
			$this->notFound();
		}
	}

	public function notFound()
	{
		session()->flash('info-failed', 'Data Transaksi Tidak Ditemukan, anda mungkin telah melewati batas waktu pembayaran atau terdapat kesalahan pada nomor telepon');

		$this->searchTransaksi = null;
		$this->emit('dataNotFound');		
	}
}
