<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\HargaMember as HargaMemberModel;

class HargaMember extends Component
{
	use WithPagination;
	protected $paginationTheme = 'bootstrap';

	public $selected_harga;
	public $total_periode, $price, $status, $discount;
	
	public function render()
	{
		$prices = HargaMemberModel::orderBy('created_at', 'DESC')->paginate(10)->onEachSide(0);
		return view('livewire.harga-member', compact('prices'))->layout('layouts.dashboard');
	}

	public function action($id)
	{
		if($this->selected_harga == $id)		
		{
			$this->selected_harga = '';
		}
		elseif(!$this->selected_harga)
		{
			$this->selected_harga = $id;
		}
		elseif($this->selected_harga and $this->selected_harga != $id)
		{
			$this->selected_harga = $id;
		}
	}	

	public function resetinput()
	{
		$this->total_periode = null;
		$this->price = null;
		$this->status = null;
		$this->discount = null;
		$this->selected_harga = null;
	}

	public function store()
	{
		$this->validate([
			'total_periode' => 'required',
			'price' => 'required',
			'status' => 'required',
			'discount' => 'required',
		]);

		HargaMemberModel::create([
			'total_periode' => $this->total_periode,
			'price' => $this->price,
			'status' => $this->status,
			'discount' => $this->discount,
		]);

		session()->flash('info-success', 'Data Harga Berhasil Ditambahkan !');
		$this->resetinput();
		$this->emit('dataAdded');
	}

	public function edit($id)
	{
		$price = HargaMemberModel::find($id);
		$this->total_periode = $price->total_periode;
		$this->price = $price->price;
		$this->status = $price->status;
		$this->discount = $price->discount;
	}

	public function update()
	{
		if($this->selected_harga)
		{
			$price = HargaMemberModel::find($this->selected_harga);
			$price->update([
				'total_periode' => $this->total_periode,
				'price' => $this->price,
				'status' => $this->status,
				'discount' => $this->discount,
			]);

			session()->flash('info-success', 'Data Harga Berhasil Diupdate !');

			$this->resetinput();
			$this->emit('dataUpdated');
		}
	}

	public function destroy()
	{
		$price = HargaMemberModel::find($this->selected_harga);
		$price->delete();

		session()->flash('info-success', 'Data Harga Terhapus !');

		$this->resetinput();
		$this->emit('dataDeleted');
	}
}
