<?php

namespace App\Http\Livewire;

use App\Models\Gallery;
use Livewire\Component;

use App\Models\Lapangan;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Storage;

class GalleryAdmin extends Component
{
	use WithFileUploads;

	public $ids, $deskripsi, $photo, $img_id;
	public $selected_image, $cabang;

	public function mount($id, $branch)
	{
		$this->ids = $id;
		$this->cabang = $branch;
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}


	public function render()
	{
		$this->changeDB();

		$field = Lapangan::where('id', $this->ids)->first();
		$galleries = Gallery::where('lapangan_id', $this->ids)->orderBy('created_at', 'DESC')->get();
		return view('livewire.gallery-admin', compact('field', 'galleries'))->layout('layouts.dashboard');
	}

	public function action($id)
	{
		if($this->selected_image == $id)		
		{
			$this->selected_image = '';
		}
		elseif(!$this->selected_image)
		{
			$this->selected_image = $id;
		}
		elseif($this->selected_image and $this->selected_image != $id)
		{
			$this->selected_image = $id;
		}
	}

	public function store()
	{
		$this->changeDB();

		$this->validate([
			'photo' => 'image|max:2048|required',
		]);

		$imageName = md5($this->photo.microtime().'.'.$this->photo->extension());

		Storage::putFileAs(
			'public/galleries', $this->photo, $imageName
		);

		Gallery::create([
			'lapangan_id' => $this->ids,
			'description' => $this->deskripsi,
			'photo' => $imageName,
		]);

		session()->flash('info-success', 'Foto Berhasil Ditambahkan');

		$this->deskripsi = '';
		$this->photo = '';
		$this->emit('dataAdded');		
	}

	public function edit($id)
	{
		$this->changeDB();
		$this->img_id = $id;
	}

	public function update()
	{
		$this->changeDB();

		$gallery = Gallery::where('id', $this->img_id)->first();
		$field = Lapangan::find($this->ids);

		$field->update([
			'thumbnail' => $gallery->photo,
		]);

		session()->flash('info-success', 'Foto Berhasil Dijadikan Thumbnail !');

		$this->img_id = '';
		$this->selected_image = '';
		$this->emit('dataUpdated');		
	}

	public function destroy($id)
	{
		$this->changeDB();
		
		if($id)
		{
			Gallery::where('id', $id)->delete();
			session()->flash('info-success', 'Data Gambar Terhapus !');

			$this->deskripsi = '';
			$this->photo = '';
			$this->img_id = '';
			$this->selected_image = '';
			$this->emit('dataDeleted');
		}
	}
}
