<?php

namespace App\Http\Livewire;

use Carbon\Carbon;

use Livewire\Component;
use Livewire\WithPagination;

use Illuminate\Support\Facades\DB;

use App\Models\TransaksiLapangan;
use App\Models\TransaksiLapanganDetail;

class DaftarBooking extends Component
{
	use WithPagination;
	protected $paginationTheme = 'bootstrap';

	public $searchTerm;
	public $selected_transaksi;
	public $detail_transkasi, $bukti, $status, $down_payment;
	public $filter_status, $filter_tanggal, $filter_bulan, $cabang;
	public $tgl;

	public function mount($branch)
	{		
		$this->cabang = $branch;

		$this->checkPaidStatus();
	}

	public function changeDB()
	{
		if($this->cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($this->cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
	}

	public function render()
	{
		$this->changeDB();

		$tanggal_booking = DB::table('transaksi_lapangan_details')->select('tanggal_booking')->groupByRaw('tanggal_booking')->get();

		if($this->selected_transaksi)
		{
			$this->detail_transkasi = TransaksiLapanganDetail::where('transaksi_lapangan_id', $this->selected_transaksi)->get();
		}			

		if($this->filter_tanggal)
		{
			$gal = $this->filter_tanggal;
			$gal = Carbon::parse($gal);
			$gal = $gal->locale('id');
			$gal->settings(['formatFunction' => 'translatedFormat']);

			$this->tgl = $gal->format('Y-m-d');
		}

		$searchTerm = '%'.$this->searchTerm . '%';

		if($this->filter_bulan)
		{
			$blan = $this->filter_bulan;
			$blan = Carbon::parse($blan);
			$mth = $blan->format('m');
			$thun = $blan->format('Y');			
			// dd($trs);
		}
		
		if($this->filter_bulan)
		{
			$this->filter_tanggal = null;
		}
		if($this->filter_tanggal)
		{
			$this->filter_bulan = null;
		}		

		if($this->filter_status)
		{
			if($this->filter_tanggal)
			{
				$transaksi = TransaksiLapangan::where([
					['status', $this->filter_status],
					['nama', 'LIKE', $searchTerm],
					['tanggal_booking', $this->filter_tanggal]
				])
				->orWhere([
					['status', $this->filter_status],
					['telepon', 'LIKE', $searchTerm],
					['tanggal_booking', $this->filter_tanggal]
				])
				->orderBy('created_at','DESC')
				->paginate(10)
				->onEachSide(0);	
			}
			if($this->filter_bulan)
			{
				$transaksi = TransaksiLapangan::where([
					['status', $this->filter_status],
					['nama', 'LIKE', $searchTerm]
				])->whereMonth('tanggal_booking', $mth)->whereYear('tanggal_booking', $thun)			
				->orWhere([
					['status', $this->filter_status],
					['telepon', 'LIKE', $searchTerm]
				])->whereMonth('tanggal_booking', $mth)->whereYear('tanggal_booking', $thun)			
				->orderBy('created_at','DESC')
				->paginate(10)
				->onEachSide(0);	
			}
			else
			{
				$transaksi = TransaksiLapangan::where([
					['status', $this->filter_status],
					['nama', 'LIKE', $searchTerm]
				])
				->orWhere([
					['status', $this->filter_status],
					['telepon', 'LIKE', $searchTerm]
				])
				->orderBy('created_at','DESC')
				->paginate(10)
				->onEachSide(0);	
			}

			return view('livewire.daftar-booking', compact('transaksi', 'tanggal_booking'))->layout('layouts.dashboard');			
		}

		else
		{
			if($this->filter_tanggal)
			{
				$transaksi = TransaksiLapangan::where([
					['nama','LIKE',$searchTerm],
					['tanggal_booking', $this->filter_tanggal]
				])
				->orWhere([
					['telepon','LIKE',$searchTerm],
					['tanggal_booking', $this->filter_tanggal]
				])
				->orderBy('created_at','DESC')
				->paginate(10)
				->onEachSide(0);				
			}
			else if($this->filter_bulan)
			{
				$transaksi = TransaksiLapangan::whereMonth('tanggal_booking', $mth)
				->whereYear('tanggal_booking', $thun)			
				->orderBy('created_at','DESC')
				->paginate(10)
				->onEachSide(0);	
			}
			else
			{
				$transaksi = TransaksiLapangan::where('nama','LIKE',$searchTerm)
				->orWhere('telepon','LIKE',$searchTerm)
				->orderBy('created_at','DESC')
				->paginate(10)
				->onEachSide(0);
			}
			
			return view('livewire.daftar-booking', compact('transaksi', 'tanggal_booking'))->layout('layouts.dashboard');
		}				
	}

	public function action($id)
	{
		if($this->selected_transaksi == $id)		
		{
			$this->selected_transaksi = '';
		}
		elseif(!$this->selected_transaksi)
		{
			$this->selected_transaksi = $id;
		}
		elseif($this->selected_transaksi and $this->selected_transaksi != $id)
		{
			$this->selected_transaksi = $id;
		}
	}

	public function resetSearch()
	{
		$this->searchTerm = '';
	}

	public function edit($id)
	{
		$this->changeDB();

		$trans = TransaksiLapangan::where('id', $id)->first();
		$this->bukti = $trans->bukti_transaksi;
		
		$this->status = $trans->status;
	}

	function update()
	{
		$this->changeDB();

		if($this->selected_transaksi)
		{
			$this->validate([
				'status' => 'required'
			]);

			$dp = null;
			if ($this->status == 'down_payment')
			{
				$dp = $this->down_payment;
			}

			$trans = TransaksiLapangan::find($this->selected_transaksi);
			$trans->update([
				'status' => $this->status,
				'down_payment' => $dp,
			]);

			session()->flash('info-success', 'Product Updated Successfully !');

			$this->status = '';
			$this->selected_transaksi = '';

			$this->emit('dataUpdated');
		}
	}

	public function checkPaidStatus()
	{		
		$this->changeDB();

		$now = Carbon::now()->locale('id');
		$now->settings(['formatFunction' => 'translatedFormat']);		

		$this->bookers = TransaksiLapangan::where('status', 'belum_bayar')->orWhere('status', 'tidak_valid')->get();
		
		foreach ($this->bookers as $key => $value) 
		{
			if(!$this->bookers[$key]['bukti_transaksi'])
			{
				$booked_at = $this->bookers[$key]['created_at'];
				$expired = $this->bookers[$key]['created_at']->addMinutes(120);

				if($expired->format('Y-m-d H:i') <= $now->format('Y-m-d H:i'))
				{
					$this->bookers[$key]->delete();
				}
			}
			if($this->bookers[$key]['status'] == 'tidak_valid')
			{
				$this->bookers[$key]->delete();
			}
		}
	}
}
