<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
	use AuthenticatesUsers;

	public $cabang;
	protected $redirectTo = RouteServiceProvider::HOME;

	protected function redirectTo()
	{
		if(auth()->user()->role == 1)
		{
			return route('admin');
		}
		elseif(auth()->user()->role == 2)
		{
			return route('admin');
		}
	}

	public function __construct()
	{
		$this->middleware('guest')->except('logout');
	}

	public function index($branch)
	{
		$this->cabang = $branch;
		$cbg = $this->cabang;
		return view('login', compact('cbg'));
	}

	public function login(Request $request, $branch)
	{
		$cabang = $branch;

		$validation = $this->validate($request, [		
			'email' => 'required|email',
			'password' => 'required',
		]);

		// Switch Between Databases
		if($cabang == 'mampang')
		{
			$database = 'mysql';
		}
		elseif($cabang == 'kalibata')
		{
			$database = 'mysql2';
		}
		else
		{
			return redirect()->route('pilih-cabang');
		}

		\Config::set('database.default', $database);
		// Switch Between Databases
	
		if (!auth()->attempt($request->only('email','password'), $request->remember))
		{
			return back()->with('status-failed','Login Gagal, Email atau Password Salah');
		}

		if(Auth::user()->hasRole('operator'))
		{
			return redirect()->route('daftar-booking');
		}
		else if(Auth::user()->hasRole('admin'))
		{
			return redirect()->route('kelola.lapangan', ['branch' => $cabang]);
		}			
	}

	public function logout()
	{
		auth()->logout();
		return redirect()->route('pilih-cabang');
	}
}
